/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawningTweak;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers.SpawnActionNPCTrainer;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers.SpawnInfoNPCTrainer;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.ISeedReader;

public class UltraSpaceLevelTweak
implements SpawningTweak {
    @Override
    public void doTweak(AbstractSpawner spawner, SpawnAction<? extends Entity> action) {
        if (action instanceof SpawnActionPokemon) {
            SpawnActionPokemon actionPokemon = (SpawnActionPokemon)action;
            if (!(action.spawnInfo instanceof SpawnInfoPokemon)) {
                return;
            }
            SpawnInfoPokemon spawnInfo = (SpawnInfoPokemon)action.spawnInfo;
            PixelmonEntity pixelmon = (PixelmonEntity)actionPokemon.getOrCreateEntity();
            if (pixelmon.isBossPokemon()) {
                return;
            }
            int newLevel = this.getTweakedLevel(actionPokemon, actionPokemon.pokemon.getPokemonLevel(), spawnInfo.minLevel, spawnInfo.maxLevel);
            pixelmon.getPokemon().setLevel(newLevel);
            pixelmon.func_70606_j(pixelmon.getPokemon().getHealth());
        } else if (action instanceof SpawnActionNPCTrainer) {
            SpawnActionNPCTrainer actionTrainer = (SpawnActionNPCTrainer)action;
            SpawnInfoNPCTrainer infoTrainer = (SpawnInfoNPCTrainer)actionTrainer.spawnInfo;
            NPCTrainer trainer = (NPCTrainer)((Object)actionTrainer.getOrCreateEntity());
            trainer.setPokemonLevel(this.getTweakedLevel(actionTrainer, trainer.pokemonLevel, infoTrainer.getMinLevel(), infoTrainer.getMaxLevel()));
        }
    }

    public int getTweakedLevel(SpawnAction<? extends Entity> action, int level, int min, int max) {
        if (min == max || !(action.spawnLocation.cause instanceof ServerPlayerEntity) || action.spawnLocation.location == null || action.spawnLocation.location.pos == null) {
            return level;
        }
        ServerPlayerEntity cause = (ServerPlayerEntity)action.spawnLocation.cause;
        if (!UltraSpace.is((ISeedReader)cause.func_71121_q())) {
            return level;
        }
        return (int)(PixelmonConfigProxy.getSpawning().getUltraSpaceLevelMultiplier() * (double)level);
    }
}

