/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCondition;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;

public class LevelByDistanceEvolutionCondition
implements SpawnerCondition {
    @Override
    public boolean fits(AbstractSpawner spawner, SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        if (!(spawnInfo instanceof SpawnInfoPokemon)) {
            return true;
        }
        SpawnInfoPokemon spawn = (SpawnInfoPokemon)spawnInfo;
        PokemonSpecification spec = spawn.getPokemonSpec();
        Species species = spawn.getSpecies();
        RegistryValue specSpecies = spec.getValue(SpeciesRequirement.class).orElse(null);
        if (spec != null && specSpecies != null && species != null && specSpecies.isInitialized()) {
            Stats stats = spec.getValue(FormRequirement.class).map(species::getForm).orElse(species.getDefaultForm());
            int levelBase = SpawnActionPokemon.getPokemonLevelBasedOnDistance(spawnLocation);
            int min = Math.max(levelBase - 5, 1);
            int max = Math.min(levelBase + 5, PixelmonConfigProxy.getSpawning().getLevelDistance().getMaxLevelByDistance());
            if (min > PixelmonServerConfig.maxLevel || max < 1) {
                return false;
            }
        }
        return true;
    }
}

