/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;

public class RubyItem
extends PixelmonItem {
    public RubyItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78035_l));
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (!player.field_70170_p.field_72995_K) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            if (entity instanceof PixelmonEntity) {
                PixelmonEntity pixelmon = (PixelmonEntity)entity;
                Species lakeGuardian = pixelmon.getSpecies();
                if (!(pixelmon.isPokemon(PixelmonSpecies.AZELF) || pixelmon.isPokemon(PixelmonSpecies.MESPRIT) || pixelmon.isPokemon(PixelmonSpecies.UXIE))) {
                    return false;
                }
                if (pixelmon.isOwnedBy((LivingEntity)player)) {
                    LakeTrioStats lakeTrioStats = (LakeTrioStats)pixelmon.getPokemon().getExtraStats();
                    if (lakeTrioStats.numEnchanted < PixelmonConfigProxy.getGeneral().getLakeTrioMaxEnchants()) {
                        if (pixelmon.getPokemon().getFriendship() >= 255) {
                            if (pixelmon.getLvl().getPokemonLevel() >= 60) {
                                ++lakeTrioStats.numEnchanted;
                                pixelmon.getLvl().setLevel(pixelmon.getLvl().getPokemonLevel() / 2 + 10);
                                pixelmon.getPokemon().setFriendship(200);
                                ChatHandler.sendFormattedChat((ICommandSource)playerMP, TextFormatting.GREEN, "ruby.success", pixelmon.getNickname());
                                pixelmon.update(EnumUpdateType.Stats);
                                pixelmon.update(EnumUpdateType.Friendship);
                                PixelmonItem fromGuardian = PixelmonItems.getRubyFromGuardian(pixelmon.getSpecies());
                                if (fromGuardian != null) {
                                    stack.func_190918_g(1);
                                    DropItemHelper.giveItemStack(playerMP, new ItemStack((IItemProvider)fromGuardian), false);
                                }
                            } else {
                                ChatHandler.sendFormattedChat((ICommandSource)playerMP, TextFormatting.GRAY, "ruby.fail.pokemonLevel", pixelmon.getNickname());
                            }
                        } else {
                            ChatHandler.sendFormattedChat((ICommandSource)playerMP, TextFormatting.GRAY, "ruby.fail.happiness", pixelmon.getNickname());
                        }
                    } else {
                        ChatHandler.sendFormattedChat((ICommandSource)playerMP, TextFormatting.GRAY, "ruby.fail.count", pixelmon.getNickname());
                    }
                } else {
                    ChatHandler.sendFormattedChat((ICommandSource)playerMP, TextFormatting.GRAY, "ruby.fail.owner", pixelmon.getNickname());
                }
            }
        }
        return false;
    }
}

