/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import net.minecraft.item.Item;

public abstract class PPRestoreItem
extends PixelmonItem {
    protected boolean allPP;

    public PPRestoreItem(boolean allPP) {
        super(new Item.Properties().func_200917_a(16).func_200916_a(PixelmonItemGroups.TAB_RESTORATION));
        this.allPP = allPP;
    }

    public static boolean restorePP(PokemonLink userPokemon, int moveIndex, boolean allPP) {
        if (moveIndex == -1) {
            moveIndex = 0;
        }
        return PPRestoreItem.restorePP(userPokemon, userPokemon.getMoveset().get(moveIndex), 10, allPP);
    }

    public static boolean restorePP(PokemonLink userPokemon, Attack m, int pp, boolean allPP) {
        if (m == null || m.pp >= m.getMaxPP()) {
            return false;
        }
        m.pp = allPP ? m.getMaxPP() : Math.min(m.pp + pp, m.getMaxPP());
        if (userPokemon instanceof WrapperLink) {
            PixelmonWrapper wp = ((WrapperLink)userPokemon).getPokemonWrapper();
            wp.setTemporaryMoveset(wp.temporaryMoveset);
        } else if (userPokemon instanceof DelegateLink) {
            userPokemon.getPokemon().markDirty(EnumUpdateType.Moveset);
        }
        return true;
    }

    protected String getMessage(boolean success) {
        return success ? "pixelmon.interaction.pprestore" : "pixelmon.interaction.ppfail";
    }
}

