/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.ai.naivgator.ProxyPathNavigator;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.events.RidePokemonEvent;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.AIHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractHasStatsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.PixelmonInteraction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public abstract class AbstractInteractionsEntity
extends AbstractHasStatsEntity {
    public static final DataSync<AbstractInteractionsEntity, Byte> SYNC_INTERACTIONS = new DataSync<AbstractInteractionsEntity, Byte>(AbstractInteractionsEntity.class, DataSerializers.field_187191_a, (abstractInteractionsEntity, interactions) -> {
        abstractInteractionsEntity.numInteractions = interactions.byteValue();
    });
    protected int ridingPlayerVertical;
    protected boolean isFlying = false;
    protected int initAir = 0;
    protected boolean ridingInitialised = false;
    protected AIHelper aiHelper;
    protected int aggressionTimer = 0;
    protected PixelmonInteraction interaction;
    protected int numInteractions = 0;
    public float mountBoost = 1.0f;
    protected int jumpTicks = 0;
    public String skillId;
    public int targetX;
    public int targetY;
    public int targetZ;
    public Direction targetSide;

    public AbstractInteractionsEntity(EntityType<? extends AbstractInteractionsEntity> type, World par1World) {
        super((EntityType<? extends AbstractHasStatsEntity>)type, par1World);
    }

    @Override
    protected void func_70088_a() {
        this.define(SYNC_INTERACTIONS, (byte)0);
        super.func_70088_a();
    }

    public AIHelper getAIHelper() {
        if (this.aiHelper == null) {
            this.resetAI();
        }
        return this.aiHelper;
    }

    public void resetAI() {
        if (!(this.field_70699_by instanceof ProxyPathNavigator)) {
            return;
        }
        this.aiHelper = new AIHelper();
        ((ProxyPathNavigator)this.field_70699_by).setProxiedNavigator(this.aiHelper.createNavigator(this));
        this.aiHelper.populateTasks(this, this.field_70714_bg);
    }

    protected void func_184651_r() {
        this.aiHelper.populateTasks(this, this.field_70714_bg);
    }

    protected void func_205714_dM() {
    }

    protected PathNavigator func_175447_b(World world) {
        this.aiHelper = new AIHelper();
        return new ProxyPathNavigator((MobEntity)this, world, this.aiHelper.createNavigator(this));
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ActionResultType actionResultType;
        if (player.field_70170_p.field_72995_K) {
            return super.func_230254_b_(player, hand);
        }
        if (hand == Hand.OFF_HAND) {
            return ActionResultType.FAIL;
        }
        if (this.interaction != null && this.getNumInteractions() > 0 && this.interaction.processInteract(this, player, hand, player.func_184586_b(hand))) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_184586_b(Hand.MAIN_HAND) != null && (actionResultType = player.func_184586_b(Hand.MAIN_HAND).func_111282_a_(player, (LivingEntity)this, Hand.MAIN_HAND)) != ActionResultType.PASS) {
            return actionResultType;
        }
        if (hand == Hand.MAIN_HAND) {
            boolean allowMount;
            if (player.func_184218_aH() || !PixelmonConfigProxy.getGeneral().getRiding().isAllowRiding() || !this.getForm().getMovement().isRideable() || !this.belongsTo(player)) {
                return super.func_230254_b_(player, hand);
            }
            if (!(PixelmonConfigProxy.getGeneral().getRiding().isLandMount() || this.canFly() || this.canSurf())) {
                return super.func_230254_b_(player, hand);
            }
            boolean bl = allowMount = !Pixelmon.EVENT_BUS.post((Event)new RidePokemonEvent((ServerPlayerEntity)player, (PixelmonEntity)this));
            if (!allowMount) {
                return super.func_230254_b_(player, hand);
            }
            player.func_184220_m((Entity)this);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean canFly() {
        if (PixelmonConfigProxy.getGeneral().getRiding().isRequireHM()) {
            Moveset moves = this.getPokemon().getMoveset();
            return this.getForm().getMovement().canFly() && moves.hasAttack(AttackRegistry.FLY);
        }
        return this.getForm().getMovement().canFly();
    }

    public boolean canSurf() {
        if (PixelmonConfigProxy.getGeneral().getRiding().isRequireHM()) {
            Moveset moves = this.getPokemon().getMoveset();
            return this.getForm().getMovement().canSurf() && moves.hasAttack(AttackRegistry.SURF);
        }
        return this.getForm().getMovement().canSurf();
    }

    public void onSendout() {
        if (!this.field_70170_p.field_72995_K && this.interaction == null) {
            this.interaction = PixelmonInteraction.getInteraction(this.getSpecies());
            if (this.interaction != null) {
                this.setNumInteractions(this.pokemon.getPersistentData().func_74771_c("NumInteractions"));
                this.interaction.counter = this.pokemon.getPersistentData().func_74765_d("InteractionCount");
                if (this.interaction.counter == -1 && this.interaction.maxInteractions != this.getNumInteractions()) {
                    this.interaction.resetCounter(this);
                }
            }
        }
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.9;
    }

    private boolean isFlying() {
        return this instanceof AbstractMovesEntity && ((AbstractMovesEntity)this).isFlying();
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
    }

    protected void updateEntityActionStateAlt() {
        ++this.field_70708_bq;
        this.func_70623_bb();
        if (Double.isNaN(this.func_226277_ct_()) || Double.isNaN(this.func_226278_cu_()) || Double.isNaN(this.func_226281_cx_())) {
            return;
        }
        this.func_70635_at().func_75523_a();
        this.field_70699_by.func_220970_c(this.func_233580_cy_());
        this.func_70619_bc();
        if (this.func_184218_aH() && this.func_184187_bx() instanceof MobEntity) {
            MobEntity entityliving = (MobEntity)this.func_184187_bx();
            entityliving.func_70661_as().func_75484_a(this.func_70661_as().func_75505_d(), 1.5);
        }
        this.field_70765_h.func_75641_c();
        if (!this.isFlying()) {
            this.func_70671_ap().func_75649_a();
            this.field_70767_i.func_75661_b();
        }
    }

    public void func_241204_bJ_() {
        if (this.interaction != null && !this.field_70170_p.field_72995_K) {
            this.pokemon.getPersistentData().func_74774_a("NumInteractions", (byte)this.numInteractions);
            this.pokemon.getPersistentData().func_74777_a("InteractionCount", (short)this.interaction.counter);
        }
        super.func_241204_bJ_();
    }

    public void func_70624_b(LivingEntity entity) {
        this.skillId = null;
        super.func_70624_b(entity);
    }

    public void setAttackTarget(LivingEntity entity, String skillId) {
        this.func_70624_b(entity);
        this.skillId = skillId;
    }

    public void setBlockTarget(int x, int y, int z, Direction side, String skillId) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.targetSide = side;
        this.skillId = skillId;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.interaction != null) {
            if (this.interaction.counter > 0) {
                --this.interaction.counter;
            }
            if (this.interaction.counter == 0) {
                this.setNumInteractions(Math.min(this.interaction.maxInteractions, this.getNumInteractions() + 1));
                if (this.interaction.maxInteractions > this.getNumInteractions()) {
                    this.interaction.resetCounter(this);
                } else {
                    --this.interaction.counter;
                }
            }
        }
        if (this.func_184179_bs() != null && !this.ridingInitialised) {
            this.initAir = this.func_184179_bs().func_70086_ai();
            this.ridingInitialised = true;
        } else if (this.func_184179_bs() == null && this.ridingInitialised) {
            this.ridingInitialised = false;
            this.resetAI();
        }
        if (!this.field_70170_p.field_72995_K && this.aiHelper == null && this.getForm() != null) {
            this.resetAI();
        }
        if (this.aggressionTimer > 0) {
            --this.aggressionTimer;
        }
    }

    public int getNumInteractions() {
        return this.numInteractions;
    }

    public void setNumInteractions(int newValue) {
        SYNC_INTERACTIONS.set((Entity)this, (Object)((byte)Math.max(0, newValue)));
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.interaction != null && !this.field_70170_p.field_72995_K) {
            this.pokemon.getPersistentData().func_74774_a("NumInteractions", (byte)this.numInteractions);
            this.pokemon.getPersistentData().func_74777_a("InteractionCount", (short)this.interaction.counter);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (!this.field_70170_p.field_72995_K && this.interaction != null) {
            this.setNumInteractions(this.pokemon.getPersistentData().func_74771_c("NumInteractions"));
            this.interaction.counter = this.pokemon.getPersistentData().func_74765_d("InteractionCount");
        }
    }

    protected boolean getUsingRidingSpecialConditions() {
        if (Math.abs(this.func_213322_ci().func_82615_a()) > 0.01 || Math.abs(this.func_213322_ci().func_82616_c()) > 0.01) {
            if (this.getSpecies().is(PixelmonSpecies.GYARADOS)) {
                return this.func_70090_H();
            }
            return this.getSpecies().is(PixelmonSpecies.ONIX);
        }
        return false;
    }

    public void unloadEntity() {
        if (this.func_184179_bs() != null) {
            this.func_184179_bs().func_233575_bb_();
            this.resetAI();
        }
        if (this.func_184187_bx() != null) {
            this.func_233575_bb_();
        }
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public int getAggressionTimer() {
        return this.aggressionTimer;
    }

    public void setAggressionTimer(int aggressionTimer) {
        this.aggressionTimer = aggressionTimer;
    }

    public int getJumpTicks() {
        return this.jumpTicks;
    }

    public void setJumpTicks(int jumpTicks) {
        this.jumpTicks = jumpTicks;
    }

    public int getRidingPlayerVertical() {
        return this.ridingPlayerVertical;
    }

    public void setRidingPlayerVertical(int ridingPlayerVertical) {
        this.ridingPlayerVertical = ridingPlayerVertical;
    }
}

