/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.wiki;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.command.WikiCommandStrategy;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.daycare.DayCareDuration;
import com.pixelmonmod.pixelmon.api.daycare.DayCareRequirement;
import com.pixelmonmod.pixelmon.api.daycare.impl.PixelmonDayCareCondition;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.AbstractRequirement;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.ItemStackRequirement;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.OneTimeFemaleItemStackRequirement;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.PokeDollarsRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.DayCareHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PokemonHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class DayCareStrategy
extends WikiCommandStrategy {
    public DayCareStrategy() {
        super("daycare");
    }

    @Override
    public int getPriority() {
        return 80;
    }

    @Override
    public Optional<ITextComponent> getBanner(CommandSource sender, Pokemon pokemon, String[] args) {
        if (pokemon.getForm().isGenderless()) {
            return Optional.empty();
        }
        return super.getBanner(sender, pokemon, args);
    }

    @Override
    public void execute(CommandSource sender, Pokemon pokemon, String[] args) {
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.daycare.header", PokemonHelper.getFullName(pokemon).func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD})), false);
        String egggroups = pokemon.getForm().getEggGroups().stream().map(ITranslatable::getLocalizedName).collect(Collectors.joining(", "));
        sender.func_197030_a((ITextComponent)TextHelper.space(1).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.egggroup", egggroups)), false);
        int steps = pokemon.getForm().getEggCycles() * PixelmonConfigProxy.getBreeding().getStepsPerEggCycle();
        sender.func_197030_a((ITextComponent)TextHelper.space(1).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.eggsteps", DayCareStrategy.format(steps))), false);
        sender.func_197030_a(StringTextComponent.field_240750_d_, false);
        List<PixelmonDayCareCondition> conditions = DayCareHelper.getConditions(pokemon);
        for (PixelmonDayCareCondition condition : conditions) {
            if (condition.getDurations().size() == 1) {
                DayCareDuration duration2 = condition.getDurations().get(0);
                sender.func_197030_a((ITextComponent)TextHelper.space(1).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.daycare.duration.single", duration2.getDisplay().getString())), false);
            } else if (condition.getDurations().size() > 1) {
                sender.func_197030_a((ITextComponent)TextHelper.space(1).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.daycare.duration.multiple", new Object[0])), false);
                condition.getDurations().stream().sorted(Comparator.comparing(DayCareDuration::getPriority)).forEach(duration -> sender.func_197030_a((ITextComponent)TextHelper.space(2).func_230529_a_((ITextComponent)new StringTextComponent("- ")).func_240702_b_(duration.getDisplay().getString()), false));
            }
            if (condition.getRequirements().isEmpty()) continue;
            sender.func_197030_a((ITextComponent)TextHelper.space(1).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.daycare.requirement", new Object[0])), false);
            for (DayCareRequirement requirement : condition.getRequirements()) {
                if (requirement instanceof ItemStackRequirement) {
                    ItemStackRequirement itemStackRequirement = (ItemStackRequirement)requirement;
                    for (ItemStack item : itemStackRequirement.getRequiredItems()) {
                        sender.func_197030_a((ITextComponent)TextHelper.space(2).func_230529_a_((ITextComponent)new StringTextComponent("- ")).func_240702_b_(item.func_190916_E() + "x ").func_240702_b_(item.func_200301_q().getString()).func_240700_a_(s -> s.func_240721_b_(TextFormatting.GRAY)), false);
                    }
                    continue;
                }
                if (requirement instanceof PokeDollarsRequirement) {
                    PokeDollarsRequirement dollarsRequirement = (PokeDollarsRequirement)requirement;
                    sender.func_197030_a((ITextComponent)TextHelper.space(2).func_230529_a_((ITextComponent)new StringTextComponent("- ")).func_230529_a_((ITextComponent)PixelmonCommandUtils.format("pixelmon.command.wiki.daycare.requirement.money", DayCareStrategy.format(dollarsRequirement.getAmount()))).func_240700_a_(s -> s.func_240721_b_(TextFormatting.GRAY)), false);
                    continue;
                }
                if (requirement instanceof OneTimeFemaleItemStackRequirement) {
                    OneTimeFemaleItemStackRequirement oneTimeFemaleItemStackRequirement = (OneTimeFemaleItemStackRequirement)requirement;
                    for (ItemStack item : oneTimeFemaleItemStackRequirement.getRequiredItems()) {
                        sender.func_197030_a((ITextComponent)TextHelper.space(2).func_230529_a_((ITextComponent)new StringTextComponent("- ")).func_240702_b_(item.func_190916_E() + "x ").func_240702_b_(item.func_200301_q().getString()).func_240702_b_(" ").func_230529_a_((ITextComponent)TextHelper.translate("pixelmon.command.wiki.daycare.requirement.onetime")).func_240700_a_(s -> s.func_240721_b_(TextFormatting.GRAY)), false);
                    }
                    continue;
                }
                if (!(requirement instanceof AbstractRequirement)) continue;
                AbstractRequirement abstractRequirement = (AbstractRequirement)requirement;
                sender.func_197030_a((ITextComponent)TextHelper.space(2).func_230529_a_((ITextComponent)new StringTextComponent("- ")).func_230529_a_(abstractRequirement.getError()).func_240700_a_(s -> s.func_240721_b_(TextFormatting.GRAY)), false);
            }
        }
    }

    private static String format(double amount) {
        NumberFormat format = NumberFormat.getInstance();
        format.setGroupingUsed(true);
        return format.format(amount);
    }
}

