/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.enums.EnumBerryFlavor;
import com.pixelmonmod.pixelmon.enums.EnumCurryRating;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class FillCurryDexCommand
extends PixelCommand {
    public static final List<String> RATINGS = Lists.newArrayList((Object[])new String[]{"-1", "0", "1", "2", "3", "4", "5"});
    public static final List<String> PAGES = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27"});
    public static final List<String> FLAVORS = Lists.newArrayList((Object[])new String[]{EnumBerryFlavor.SPICY.getLocalizedName(), EnumBerryFlavor.DRY.getLocalizedName(), EnumBerryFlavor.SWEET.getLocalizedName(), EnumBerryFlavor.BITTER.getLocalizedName(), EnumBerryFlavor.SOUR.getLocalizedName(), EnumBerryFlavor.NONE.getLocalizedName()});

    public FillCurryDexCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "fillcurrydex", "/fillcurrydex [player] [rating] [page] [flavor]", 4);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 2) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage storage = StorageProxy.getParty(target);
        int curryDexRating = this.parseCurryDexRating(args);
        int curryDexPage = this.parseCurryDexPage(args);
        int curryDexFlavor = this.parseCurryDexFlavor(args);
        String curryDexRatingName = "Unearned";
        if (curryDexRating >= 0) {
            curryDexRatingName = EnumCurryRating.ratingFromOrdinal(curryDexRating).getLocalizedName();
        }
        String curryDexFlavorName = EnumBerryFlavor.berryFromOrdinal(curryDexFlavor).getLocalizedName();
        TextFormatting curryDexFlavorColor = this.formatCurryFlavorColor(curryDexFlavor);
        TextFormatting curryDexRatingColor = this.formatCurryRatingColor(curryDexRating);
        if (curryDexRating == -10) {
            storage.fillEntireCurryDex(EnumCurryRating.CHARIZARD.ordinal());
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.YELLOW, "pixelmon.command.fillcurrydex.complete", target.func_200200_C_()), false);
        } else if (curryDexPage == -10) {
            if (curryDexRating > 4 || curryDexRating < -2) {
                sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.invalidslot", curryDexRating));
                return;
            }
            storage.fillEntireCurryDex(curryDexRating);
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GRAY, "pixelmon.command.fillcurrydex.entire", target.func_200200_C_(), "" + curryDexRatingColor + curryDexRatingName), false);
        } else if (curryDexFlavor == -10) {
            if (curryDexPage > 24 || curryDexPage < 0) {
                sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.invalidslot", curryDexPage + 1));
                return;
            }
            storage.fillOneCurryDexPage(curryDexPage, curryDexRating);
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GRAY, "pixelmon.command.fillcurrydex.page", curryDexPage + 1, target.func_200200_C_(), "" + curryDexRatingColor + curryDexRatingName), false);
        } else {
            if (curryDexFlavor > 5 || curryDexFlavor < 0) {
                sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.invalidslot", curryDexFlavor + 1));
                return;
            }
            storage.fillOneCurryDexFlavor(curryDexPage, curryDexFlavor, curryDexRating);
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GRAY, "pixelmon.command.fillcurrydex.flavor", "" + curryDexFlavorColor + curryDexFlavorName, curryDexPage + 1, target.func_200200_C_(), "" + curryDexRatingColor + curryDexRatingName), false);
        }
    }

    private int parseCurryDexRating(String ... args) {
        if (args.length < 2) {
            return -10;
        }
        return NumberHelper.parseInteger(args[1]).orElse(5) - 1;
    }

    private int parseCurryDexPage(String ... args) {
        if (args.length < 3) {
            return -10;
        }
        return NumberHelper.parseInteger(args[2]).orElse(0) - 1;
    }

    private int parseCurryDexFlavor(String ... args) {
        if (args.length < 4) {
            return -10;
        }
        return EnumBerryFlavor.getOrdinalFromBerry(args[3]);
    }

    public TextFormatting formatCurryFlavorColor(int curryDexFlavor) {
        switch (curryDexFlavor) {
            default: {
                return TextFormatting.WHITE;
            }
            case 0: {
                return TextFormatting.GOLD;
            }
            case 1: {
                return TextFormatting.BLUE;
            }
            case 2: {
                return TextFormatting.RED;
            }
            case 3: {
                return TextFormatting.GREEN;
            }
            case 4: {
                return TextFormatting.YELLOW;
            }
            case 5: 
        }
        return TextFormatting.GRAY;
    }

    public TextFormatting formatCurryRatingColor(int curryDexRating) {
        switch (curryDexRating) {
            case 0: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case 1: {
                return TextFormatting.DARK_AQUA;
            }
            case 2: {
                return TextFormatting.GOLD;
            }
            case 3: {
                return TextFormatting.GRAY;
            }
            default: {
                return TextFormatting.YELLOW;
            }
            case -2: 
            case -1: 
            case 5: 
        }
        return TextFormatting.DARK_GRAY;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1 && this.hasPermissionOtherTarget(sender)) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        if (args.length == 2) {
            return RATINGS;
        }
        if (args.length == 3) {
            return PAGES;
        }
        if (args.length == 4) {
            return FLAVORS;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

