/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.sync;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.pixelmon.api.pokemon.species.Pokedex;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SyncSpeciesPacket
extends AbstractPixelmonPacket {
    private List<Species> species;

    public SyncSpeciesPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    private SyncSpeciesPacket(List<Species> species) {
        this();
        this.species = species;
    }

    public static void sync(ServerPlayerEntity player) {
        List<Species> species = PixelmonSpecies.getAll();
        int groups = Math.max(1, species.size() / 100);
        int size = species.size() / groups;
        for (int group = 0; group < groups; ++group) {
            int i;
            ArrayList sublist = Lists.newArrayList();
            if (group + 1 == groups) {
                for (i = size * group; i < species.size(); ++i) {
                    sublist.add(species.get(i));
                }
            } else {
                for (i = size * group; i < size * (group + 1); ++i) {
                    sublist.add(species.get(i));
                }
            }
            NetworkHelper.sendPacket(player, new SyncSpeciesPacket(sublist));
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.species = Lists.newArrayList();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            String json = buffer.func_218666_n() + buffer.func_218666_n();
            this.species.add((Species)Species.GSON.fromJson(json, Species.class));
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.species.size());
        for (Species species : this.species) {
            int length = species.getJson().length() / 2;
            String firstHalf = species.getJson().substring(0, length);
            String secondHalf = species.getJson().substring(length);
            buffer.func_180714_a(firstHalf);
            buffer.func_180714_a(secondHalf);
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        RegistryManager.invalidateRegistry(Species.class);
        for (Species species : this.species) {
            PixelmonSpecies.addSpecies(species);
        }
        Pokedex.resetPokedex();
        Pokedex.loadPokedex();
    }
}

