/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.sync;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.init.loaders.PixelmonLoaders;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SyncPokeBallsPacket
extends AbstractPixelmonPacket {
    private List<PokeBall> pokeballs;
    private boolean last;

    public SyncPokeBallsPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    private SyncPokeBallsPacket(List<PokeBall> pokeballs, boolean last) {
        this();
        this.pokeballs = pokeballs;
        this.last = last;
    }

    public static void sync(ServerPlayerEntity player) {
        List<PokeBall> pokeballs = PokeBallRegistry.getAll();
        int groups = Math.max(1, pokeballs.size() / 100);
        int size = pokeballs.size() / groups;
        for (int group = 0; group < groups; ++group) {
            int i;
            ArrayList sublist = Lists.newArrayList();
            if (group + 1 == groups) {
                for (i = size * group; i < pokeballs.size(); ++i) {
                    sublist.add(pokeballs.get(i));
                }
            } else {
                for (i = size * group; i < size * (group + 1); ++i) {
                    sublist.add(pokeballs.get(i));
                }
            }
            NetworkHelper.sendPacket(player, new SyncPokeBallsPacket(sublist, group + 1 == groups));
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.pokeballs = Lists.newArrayList();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            String json = buffer.func_218666_n() + buffer.func_218666_n();
            this.pokeballs.add((PokeBall)PokeBallRegistry.GSON.fromJson(json, PokeBall.class));
        }
        this.last = buffer.readBoolean();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.pokeballs.size());
        for (PokeBall pokeball : this.pokeballs) {
            int length = pokeball.getJson().length() / 2;
            String firstHalf = pokeball.getJson().substring(0, length);
            String secondHalf = pokeball.getJson().substring(length);
            buffer.func_180714_a(firstHalf);
            buffer.func_180714_a(secondHalf);
        }
        buffer.writeBoolean(this.last);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        for (PokeBall pokeball : this.pokeballs) {
            PokeBallRegistry.register(pokeball);
        }
        PixelmonLoaders.tryReloadSearchTrees(this.last);
    }
}

