/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.selection;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.client.gui.custom.selection.SelectionScreen;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetSelectionOptionsPacket
extends AbstractPixelmonPacket {
    private int slot;
    private Pokemon pokemon;

    public SetSelectionOptionsPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public SetSelectionOptionsPacket(int slot, Pokemon pokemon) {
        this();
        this.slot = slot;
        this.pokemon = pokemon;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.slot = buf.readInt();
        this.pokemon = PokemonFactory.create(UUID.randomUUID()).readFromByteBuffer(buf, EnumUpdateType.ALL);
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.slot);
        this.pokemon.writeToByteBuffer(buf, EnumUpdateType.ALL);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        this.onClient(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClient(NetworkEvent.Context context) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(screen instanceof SelectionScreen)) {
            return;
        }
        ((SelectionScreen)screen).setPokemon(this.slot, this.pokemon);
        ((SelectionScreen)screen).func_231160_c_();
    }
}

