/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class NPCLearnMovePacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private EnumNPCType npcType;

    public NPCLearnMovePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public NPCLearnMovePacket(UUID pokemonUUID, EnumNPCType npcType) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
        this.npcType = npcType;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.pokemonUUID = buf.func_179253_g();
        this.npcType = EnumNPCType.getFromOrdinal(buf.readInt());
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.pokemonUUID);
        buf.writeInt(this.npcType.ordinal());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        PlayerPartyStorage party = StorageProxy.getParty(player);
        Pokemon pokemon = party.find(this.pokemonUUID);
        if (pokemon == null) {
            return;
        }
        if (this.npcType == EnumNPCType.Relearner) {
            OpenScreenPacket.open((PlayerEntity)player, EnumGuiScreen.Relearner, pokemon.getPosition().order);
        } else if (this.npcType == EnumNPCType.Tutor) {
            OpenScreenPacket.open((PlayerEntity)player, EnumGuiScreen.Tutor, pokemon.getPosition().order);
        }
    }
}

