/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.selection;

import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelection;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelectionRegistry;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.selection.CancelTeamSelectPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ConfirmTeamSelectPacket
extends AbstractPixelmonPacket {
    private int teamSelectID;
    private int[] selection;
    private boolean force;

    public ConfirmTeamSelectPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ConfirmTeamSelectPacket(int teamSelectID, int[] selection, boolean force) {
        super(PacketDirection.PLAY_SERVER, true);
        this.teamSelectID = teamSelectID;
        this.selection = selection;
        this.force = force;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.teamSelectID);
        for (int s : this.selection) {
            buf.writeInt(s);
        }
        buf.writeBoolean(this.force);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.teamSelectID = buf.readInt();
        this.selection = new int[6];
        for (int i = 0; i < this.selection.length; ++i) {
            this.selection[i] = buf.readInt();
        }
        this.force = buf.readBoolean();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        TeamSelection teamSelection = TeamSelectionRegistry.getTeamSelection(this.teamSelectID);
        if (teamSelection == null) {
            this.reply(context, new CancelTeamSelectPacket());
        } else {
            teamSelection.registerTeamSelect(player, this.selection, this.force);
        }
    }
}

