/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SetStrugglePacket
extends AbstractPixelmonPacket {
    private boolean[][] targetting;
    private int battleIndex;
    private UUID pokemonUUID;

    public SetStrugglePacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public SetStrugglePacket(UUID pokemonUUID, boolean[][] targetting, int battleIndex) {
        super(PacketDirection.PLAY_SERVER);
        this.pokemonUUID = pokemonUUID;
        this.battleIndex = battleIndex;
        this.targetting = targetting;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        int i;
        this.pokemonUUID = buffer.func_179253_g();
        this.battleIndex = buffer.readInt();
        this.targetting = new boolean[buffer.readShort()][];
        for (i = 0; i < this.targetting.length; ++i) {
            this.targetting[i] = new boolean[buffer.readShort()];
        }
        for (i = 0; i < this.targetting.length; ++i) {
            for (int j = 0; j < this.targetting[i].length; ++j) {
                this.targetting[i][j] = buffer.readBoolean();
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.pokemonUUID);
        buffer.writeInt(this.battleIndex);
        buffer.writeShort(this.targetting.length);
        for (boolean[] aTargetting1 : this.targetting) {
            buffer.writeShort(aTargetting1.length);
        }
        for (boolean[] aTargetting : this.targetting) {
            for (int j = 0; j < aTargetting.length; ++j) {
                buffer.writeBoolean(aTargetting[j]);
            }
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        BattleController bc = BattleRegistry.getBattle(this.battleIndex);
        for (BattleParticipant p : bc.participants) {
            if (!(p instanceof PlayerParticipant) || !((PlayerParticipant)p).player.func_110124_au().equals(context.getSender().func_110124_au())) continue;
            for (PixelmonWrapper pw : p.controlledPokemon) {
                if (!pw.getPokemonUUID().equals(this.pokemonUUID)) continue;
                pw.setStruggle((ArrayList)this.findTargets(this, bc, p));
            }
        }
    }

    private List<PixelmonWrapper> findTargets(SetStrugglePacket message, BattleController bc, BattleParticipant p) {
        ArrayList targets = Lists.newArrayList();
        ArrayList<PixelmonWrapper> teamPokemon = bc.getTeamPokemon(p);
        for (int i = 0; i < message.targetting[0].length; ++i) {
            if (!message.targetting[0][i]) continue;
            targets.add(teamPokemon.get(i));
        }
        ArrayList<PixelmonWrapper> opponentPokemon = bc.getOpponentPokemon(p);
        for (int i = 0; i < message.targetting[1].length; ++i) {
            if (!message.targetting[1][i]) continue;
            targets.add(opponentPokemon.get(i));
        }
        return targets;
    }
}

