/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ShowSpectateMessagePacket;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class CheckPlayerBattlePacket
extends AbstractPixelmonPacket {
    private UUID uuid;

    public CheckPlayerBattlePacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public CheckPlayerBattlePacket(PlayerEntity player) {
        super(PacketDirection.PLAY_SERVER);
        this.uuid = player.func_110124_au();
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.uuid = new UUID(buffer.readLong(), buffer.readLong());
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeLong(this.uuid.getMostSignificantBits());
        buffer.writeLong(this.uuid.getLeastSignificantBits());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity sender = context.getSender();
        if (sender == null || sender.field_70170_p == null || this.uuid == null) {
            return;
        }
        PlayerEntity player = sender.field_70170_p.func_217371_b(this.uuid);
        if (player != null && BattleRegistry.getBattleExcludeSpectate(player) != null) {
            this.reply(context, new ShowSpectateMessagePacket(this.uuid));
        }
    }
}

