/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.status.Transformed;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class TransformPacket
extends AbstractPixelmonPacket {
    public int pixelmonID;
    public Species transformedModel;
    public String transformedTexture;
    public String transformedForm;
    public String transformedParticles;

    public TransformPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public TransformPacket(int is, Species newPokemon, String newTexture, String newForm, String newParticles) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.transformedModel = newPokemon;
        this.transformedTexture = newTexture;
        this.transformedForm = newForm.contains("gmax") ? newPokemon.getForm(newForm).getDefaultBaseForm() : newForm;
        this.transformedParticles = newParticles;
        this.pixelmonID = is;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.pixelmonID = buffer.readInt();
        this.transformedModel = PixelmonSpecies.fromNationalDex(buffer.readInt());
        this.transformedTexture = buffer.func_218666_n();
        this.transformedForm = buffer.func_218666_n();
        this.transformedParticles = buffer.func_218666_n();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.pixelmonID);
        buffer.writeInt(this.transformedModel.getDex());
        buffer.func_180714_a(this.transformedTexture);
        buffer.func_180714_a(this.transformedForm);
        buffer.func_180714_a(this.transformedParticles);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        Transformed.applyToClientEntity(this);
    }
}

