/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.OrbBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.OrbTileEntity;
import com.pixelmonmod.pixelmon.client.models.obj.OBJLoader;
import com.pixelmonmod.pixelmon.client.models.obj.WavefrontObject;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.enums.items.EnumOrbShard;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.state.EnumProperty;
import net.minecraft.util.ResourceLocation;

public class RenderTileEntityOrb
extends TileEntityRenderer<OrbTileEntity> {
    public static final ResourceLocation RED_ORB = ResourceLocationHelper.of("pixelmon", "textures/block/orbs/red_orb.png");
    public static final ResourceLocation BLUE_ORB = ResourceLocationHelper.of("pixelmon", "textures/block/orbs/blue_orb.png");
    public static final ResourceLocation JADE_ORB = ResourceLocationHelper.of("pixelmon", "textures/block/orbs/jade_orb.png");

    public RenderTileEntityOrb(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    public boolean hasProperty(BlockState state, EnumProperty<?> property) {
        return state.func_235904_r_().contains(property);
    }

    @Override
    public void render(OrbTileEntity tile, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        byte pieces = tile.getPieces();
        if (!(state.func_177230_c() instanceof OrbBlock)) {
            return;
        }
        if (!this.hasProperty(state, (EnumProperty<?>)OrbBlock.FACING)) {
            return;
        }
        EnumOrbShard shard = ((OrbBlock)state.func_177230_c()).shardType;
        float scale = 1.0f;
        ResourceLocation rl = RED_ORB;
        switch (shard) {
            case RED: {
                rl = RED_ORB;
                scale = 0.13f;
                break;
            }
            case BLUE: {
                rl = BLUE_ORB;
                scale = 0.06f;
                break;
            }
            case JADE: {
                rl = JADE_ORB;
            }
        }
        matrix.func_227860_a_();
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
        matrix.func_227862_a_(scale, scale, scale);
        this.renderOBJ(matrix, buffer, EnumOrbModels.getModel(shard, pieces), rl, combinedLight, combinedOverlay);
        matrix.func_227865_b_();
        if (tile.getPieces() > 9) {
            ++tile.clientTicker;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            float f = ((float)tile.clientTicker + partialTicks) / 300.0f;
            if (tile.clientTicker == Integer.MAX_VALUE) {
                tile.clientTicker = 0;
            }
            Random random = new Random(432L);
            matrix.func_227860_a_();
            scale = 3.5E-4f;
            int red = shard == EnumOrbShard.RED ? 255 : 0;
            int blue = shard == EnumOrbShard.BLUE ? 255 : 0;
            int green = shard == EnumOrbShard.JADE ? 255 : 0;
            matrix.func_227862_a_(scale, scale, scale);
            for (int i = 0; i < 3; ++i) {
                matrix.func_227863_a_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f, 1.0f, 0.0f, 0.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f, 0.0f, 1.0f, 0.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f, 0.0f, 0.0f, 1.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f, 1.0f, 0.0f, 0.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f, 0.0f, 1.0f, 0.0f));
                matrix.func_227863_a_(QuaternionHelper.fromEuler(random.nextFloat() * 360.0f + f * 90.0f, 0.0f, 0.0f, 1.0f));
                double f2 = (double)random.nextFloat() * 20.0 + 1.0 + 2000.0;
                double f3 = (double)random.nextFloat() * 2.0 + 1.0 + 400.0;
                bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                bufferbuilder.func_225582_a_(3.0, 0.0, 0.0).func_225586_a_(red, green, blue, 191).func_181675_d();
                bufferbuilder.func_225582_a_(-3.0 * f3, f2, -3.0 * f3).func_225586_a_(red, green, blue, 0).func_181675_d();
                bufferbuilder.func_225582_a_(3.0 * f3, f2, -3.0 * f3).func_225586_a_(red, green, blue, 0).func_181675_d();
                bufferbuilder.func_225582_a_(0.0, f2, f3).func_225586_a_(red, green, blue, 1).func_181675_d();
                bufferbuilder.func_225582_a_(-3.0 * f3, f2, -3.0 * f3).func_225586_a_(red, green, blue, 0).func_181675_d();
                tessellator.func_78381_a();
            }
            matrix.func_227865_b_();
        }
    }

    @Override
    public IVertexBuilder bindOBJBuffer(IRenderTypeBuffer buffer, ResourceLocation texture) {
        return buffer.getBuffer(PixelmonRendering.getOBJType(texture));
    }

    public static enum EnumOrbModels {
        RED_ONE("pixelmon:models/blocks/orbs/red/1.obj"),
        RED_TWO("pixelmon:models/blocks/orbs/red/2.obj"),
        RED_THREE("pixelmon:models/blocks/orbs/red/3.obj"),
        RED_FOUR("pixelmon:models/blocks/orbs/red/4.obj"),
        RED_FIVE("pixelmon:models/blocks/orbs/red/5.obj"),
        RED_SIX("pixelmon:models/blocks/orbs/red/6.obj"),
        RED_SEVEN("pixelmon:models/blocks/orbs/red/7.obj"),
        RED_EIGHT("pixelmon:models/blocks/orbs/red/8.obj"),
        RED_NINE("pixelmon:models/blocks/orbs/red/9.obj"),
        RED_TEN("pixelmon:models/blocks/orbs/red/10.obj"),
        BLUE_ONE("pixelmon:models/blocks/orbs/blue/1.obj"),
        BLUE_TWO("pixelmon:models/blocks/orbs/blue/2.obj"),
        BLUE_THREE("pixelmon:models/blocks/orbs/blue/3.obj"),
        BLUE_FOUR("pixelmon:models/blocks/orbs/blue/4.obj"),
        BLUE_FIVE("pixelmon:models/blocks/orbs/blue/5.obj"),
        BLUE_SIX("pixelmon:models/blocks/orbs/blue/6.obj"),
        BLUE_SEVEN("pixelmon:models/blocks/orbs/blue/7.obj"),
        BLUE_EIGHT("pixelmon:models/blocks/orbs/blue/8.obj"),
        BLUE_NINE("pixelmon:models/blocks/orbs/blue/9.obj"),
        BLUE_TEN("pixelmon:models/blocks/orbs/blue/10.obj"),
        JADE_ONE("pixelmon:models/blocks/orbs/jade/1.obj"),
        JADE_TWO("pixelmon:models/blocks/orbs/jade/2.obj"),
        JADE_THREE("pixelmon:models/blocks/orbs/jade/3.obj"),
        JADE_FOUR("pixelmon:models/blocks/orbs/jade/4.obj"),
        JADE_FIVE("pixelmon:models/blocks/orbs/jade/5.obj"),
        JADE_SIX("pixelmon:models/blocks/orbs/jade/6.obj"),
        JADE_SEVEN("pixelmon:models/blocks/orbs/jade/7.obj"),
        JADE_EIGHT("pixelmon:models/blocks/orbs/jade/8.obj"),
        JADE_NINE("pixelmon:models/blocks/orbs/jade/9.obj"),
        JADE_TEN("pixelmon:models/blocks/orbs/jade/10.obj");

        public WavefrontObject obj;
        public final ResourceLocation path;

        private EnumOrbModels(String path) {
            this.path = ResourceLocationHelper.of(path);
        }

        private WavefrontObject getModel() {
            if (this.obj == null) {
                try {
                    if (OBJLoader.accepts(this.path)) {
                        this.obj = OBJLoader.loadModel(this.path);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.obj;
        }

        public static WavefrontObject getModel(EnumOrbShard shard, int pieces) {
            return EnumOrbModels.values()[shard.ordinal() * 10 + pieces - 1].getModel();
        }
    }
}

