/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderTileEntityGeneric<G extends RenderTileEntityGeneric<G, T>, T extends TileEntity>
extends TileEntityRenderer<T> {
    protected ResourceLocation texture;
    public Model model;
    public HashMap<GenericSmdModel, ResourceLocation> childModels = Maps.newHashMap();
    protected int correctionAngles = 0;
    protected int rotateDegrees = 0;
    protected float scale = 0.0f;
    protected float yOffset = 0.0f;
    public boolean blend = false;
    public boolean disableCulling = false;
    public boolean disableLighting = false;

    public RenderTileEntityGeneric(TileEntityRendererDispatcher dispatcher, String textureFileName, Model model) {
        super(dispatcher);
        this.texture = ResourceLocationHelper.of("pixelmon:textures/block/" + textureFileName.toLowerCase(Locale.ROOT));
        this.model = model;
    }

    public RenderTileEntityGeneric(String modId, TileEntityRendererDispatcher dispatcher, String textureFileName, Model model, int correctionAngles) {
        super(dispatcher);
        this.texture = ResourceLocationHelper.of(modId, "textures/block/" + textureFileName.toLowerCase(Locale.ROOT));
        this.model = model;
        this.correctionAngles = correctionAngles;
    }

    public RenderTileEntityGeneric(TileEntityRendererDispatcher dispatcher, String textureFileName, Model model, int correctionAngles) {
        this("pixelmon", dispatcher, textureFileName, model, correctionAngles);
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    public void render(T te, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        Direction facing;
        IVertexBuilder vertexBuffer = buffer.getBuffer(RenderType.func_228645_f_());
        Block block = state.func_177230_c();
        this.rotateDegrees = block instanceof MultiBlock || block instanceof GenericRotatableModelBlock ? ((facing = block instanceof MultiBlock ? (Direction)state.func_177229_b((Property)MultiBlock.FACING) : (Direction)state.func_177229_b((Property)GenericRotatableModelBlock.FACING)) == Direction.EAST ? 270 : (facing == Direction.NORTH ? 0 : (facing == Direction.WEST ? 90 : (facing == Direction.SOUTH ? 180 : 0)))) : 0;
        RenderSystem.enableRescaleNormal();
        matrix.func_227860_a_();
        if (this.blend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.depthMask((boolean)false);
        }
        matrix.func_227861_a_(0.5, (double)this.yOffset, 0.5);
        matrix.func_227863_a_(QuaternionHelper.fromEuler(this.rotateDegrees + this.correctionAngles, 0.0f, 1.0f, 0.0f));
        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 0.0f, 0.0f, 1.0f));
        if (this.scale != 0.0f) {
            matrix.func_227862_a_(this.scale, this.scale, this.scale);
        }
        this.renderSMD(matrix, buffer, this.model, this.texture, combinedLight, combinedOverlay);
        for (Map.Entry<GenericSmdModel, ResourceLocation> childEntry : this.childModels.entrySet()) {
            this.renderSMD(matrix, buffer, childEntry.getKey(), childEntry.getValue(), combinedLight, combinedOverlay);
        }
        if (this.blend) {
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }
        RenderSystem.disableRescaleNormal();
        matrix.func_227865_b_();
    }
}

