/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.custom.dialogue;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.dialogue.Dialogue;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.RoundButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue.DialogueChoiceMadePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue.DialogueClosurePacket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.StringTextComponent;

public class DialogueScreen
extends Screen {
    private static volatile List<Dialogue> dialogues;
    private static volatile UUID quest;
    private List<RoundButton> choiceButtons = new ArrayList<RoundButton>();
    private Dialogue currentDialogue = dialogues.get(0);
    private boolean pause = false;
    protected int guiLeft;
    protected int guiTop;

    public DialogueScreen() {
        super(StringTextComponent.field_240750_d_);
        this.field_230706_i_ = Minecraft.func_71410_x();
    }

    public boolean func_231178_ax__() {
        return this.currentDialogue.escapeCloses();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - 176) / 2;
        this.guiTop = (this.field_230709_l_ - 166) / 2;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.currentDialogue == null) {
            return;
        }
        if (this.choiceButtons.isEmpty() && !this.currentDialogue.choices.isEmpty()) {
            this.loadButtons();
        }
        ScreenHelper.drawDialogueBox(matrix, (Screen)this, this.currentDialogue.name, Lists.newArrayList((Object[])new String[]{this.currentDialogue.getText()}), 0.0f);
        for (int i = 0; i < this.choiceButtons.size(); ++i) {
            this.choiceButtons.get(i).drawButton(matrix, this.getButtonX(i), this.getButtonY(i), mouseX, mouseY, 0.0f);
        }
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.disableBlend();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.pause) {
            return false;
        }
        if (this.currentDialogue.choices.isEmpty()) {
            DialogueScreen.removeImmediateDialogue();
            this.next();
            if (this.currentDialogue != null) {
                this.loadButtons();
            }
            return false;
        }
        for (int i = 0; i < this.choiceButtons.size(); ++i) {
            if (!this.choiceButtons.get(i).isMouseOver(this.getButtonX(i), this.getButtonY(i), mouseX, mouseY)) continue;
            this.pause = true;
            NetworkHelper.sendToServer(new DialogueChoiceMadePacket(this.currentDialogue.choices.get(i)));
            break;
        }
        return true;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void close() {
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }

    public void next() {
        this.pause = false;
        if (dialogues.isEmpty()) {
            this.close();
        } else {
            this.currentDialogue = dialogues.get(0);
            this.choiceButtons.clear();
        }
    }

    public static void removeImmediateDialogue() {
        if (!dialogues.isEmpty()) {
            dialogues.remove(0);
        }
    }

    public static void addDialogues(List<Dialogue> dialogues) {
        DialogueScreen.dialogues.addAll(dialogues);
    }

    public static void insertDialogues(List<Dialogue> dialogues) {
        dialogues.addAll(DialogueScreen.dialogues);
        DialogueScreen.dialogues = dialogues;
    }

    public static void setDialogues(List<Dialogue> dialogues) {
        DialogueScreen.setDialogues(dialogues, null);
    }

    public static void setDialogues(List<Dialogue> dialogues, UUID quest) {
        DialogueScreen.dialogues = dialogues;
        DialogueScreen.quest = quest;
    }

    public static boolean isQuest() {
        boolean isQuest = quest != null;
        quest = null;
        return isQuest;
    }

    private void loadButtons() {
        this.choiceButtons.clear();
        for (int i = 0; i < this.currentDialogue.choices.size(); ++i) {
            this.choiceButtons.add(new RoundButton(-30 + (230 - (this.getLargestWidth() + 20)) / 2, 65, this.currentDialogue.choices.get((int)i).text, this.getLargestWidth() + 20, 20));
        }
    }

    private int getLargestWidth() {
        int max = 0;
        for (int i = 0; i < this.currentDialogue.choices.size(); ++i) {
            if (this.field_230706_i_.field_71466_p.func_78256_a(this.currentDialogue.choices.get((int)i).text) <= max) continue;
            max = this.field_230706_i_.field_71466_p.func_78256_a(this.currentDialogue.choices.get((int)i).text);
        }
        return max;
    }

    private int getButtonX(int buttonNum) {
        return this.guiLeft;
    }

    private int getButtonY(int buttonNum) {
        return this.guiTop + 23 * buttonNum;
    }

    public void func_231164_f_() {
        NetworkHelper.sendToServer(new DialogueClosurePacket());
    }

    static {
        quest = null;
    }
}

