/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.tasks;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import java.util.TimerTask;
import java.util.UUID;

public abstract class HPTask
extends TimerTask {
    int healthDifference;
    float originalHealth;
    float currentHealth;
    double interval;
    UUID uuid;
    PixelmonClientData pokemon;
    boolean canceled = false;

    public HPTask(int healthDifference, UUID uuid) {
        this.healthDifference = healthDifference;
        this.uuid = uuid;
        this.pokemon = ClientProxy.battleManager.getPokemon(uuid);
        if (this.pokemon != null) {
            this.currentHealth = this.originalHealth = (float)this.pokemon.health.get();
            this.boundsCheck();
        }
        this.interval = (double)this.healthDifference / 100.0;
    }

    protected abstract void boundsCheck();

    @Override
    public void run() {
        if (this.pokemon == null) {
            this.cancel();
            return;
        }
        this.currentHealth = (float)((double)this.currentHealth + this.interval);
        if (this.isDone()) {
            this.cancel();
            this.pokemon.health.set((double)Math.min(Math.max(0.0f, this.originalHealth + (float)this.healthDifference), (float)this.pokemon.maxHealth));
            return;
        }
        this.pokemon.health.set((double)this.currentHealth);
    }

    @Override
    public boolean cancel() {
        this.canceled = true;
        return super.cancel();
    }

    public abstract boolean isDone();
}

