/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.blocks.GenericRotatableBlock;
import com.pixelmonmod.pixelmon.blocks.StickPlateBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MovementPlateBlock
extends GenericRotatableBlock {
    private static final int MAX_LOOP_LENGTH = 100;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public MovementPlateBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.5f));
    }

    public Boolean isLoop(World world, BlockPos posOriginal, int maxLength) {
        BlockPos posCurrent = new BlockPos((Vector3i)posOriginal);
        for (int iteration = 1; iteration < maxLength; ++iteration) {
            Direction direction = (Direction)world.func_180495_p(posCurrent).func_177229_b(GenericRotatableBlock.FACING);
            switch (direction) {
                case NORTH: {
                    posCurrent = posCurrent.func_177978_c();
                    break;
                }
                case SOUTH: {
                    posCurrent = posCurrent.func_177968_d();
                    break;
                }
                case EAST: {
                    posCurrent = posCurrent.func_177974_f();
                    break;
                }
                case WEST: {
                    posCurrent = posCurrent.func_177976_e();
                    break;
                }
                default: {
                    return false;
                }
            }
            if (!(world.func_180495_p(posCurrent).func_177230_c() instanceof MovementPlateBlock)) {
                return false;
            }
            if (!posCurrent.equals((Object)posOriginal)) continue;
            return true;
        }
        return false;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        Direction facing = (Direction)state.func_177229_b(GenericRotatableBlock.FACING);
        double speedModifier = 1.0;
        if (this.targetSticky(worldIn, pos)) {
            speedModifier = 0.4;
        }
        if (entity instanceof DenEntity) {
            return;
        }
        double distanceFromCenterX = entity.func_226277_ct_() - (double)pos.func_177958_n() - 0.5;
        double distanceFromCenterZ = entity.func_226281_cx_() - (double)pos.func_177952_p() - 0.5;
        double pushToMiddle = 0.2;
        double motionZ = 0.0;
        double motionX = 0.0;
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            motionZ = (double)facing.func_82599_e() * speedModifier;
            if (distanceFromCenterX > 0.1) {
                if (entity.func_213322_ci().field_72450_a > -0.2) {
                    motionX = -1.0 * pushToMiddle;
                }
            } else if (distanceFromCenterX < -0.1) {
                if (entity.func_213322_ci().field_72450_a < 0.2) {
                    motionX = pushToMiddle;
                }
            } else {
                motionX = 0.0;
            }
        } else if (facing == Direction.EAST || facing == Direction.WEST) {
            motionX = (double)facing.func_82601_c() * speedModifier;
            if (distanceFromCenterZ > 0.1) {
                if (entity.func_213322_ci().field_72449_c > -0.2) {
                    motionZ = -1.0 * pushToMiddle;
                }
            } else if (distanceFromCenterZ < -0.1) {
                if (entity.func_213322_ci().field_72449_c < 0.2) {
                    motionZ = pushToMiddle;
                }
            } else {
                motionZ = 0.0;
            }
        }
        entity.func_213293_j(motionX, (double)facing.func_96559_d() * speedModifier, motionZ);
    }

    public boolean targetSticky(World world, BlockPos pos) {
        BlockPos targetPos = null;
        Direction facing = (Direction)world.func_180495_p(pos).func_177229_b(FACING);
        switch (facing) {
            case NORTH: {
                targetPos = pos.func_177978_c();
                break;
            }
            case SOUTH: {
                targetPos = pos.func_177968_d();
                break;
            }
            case EAST: {
                targetPos = pos.func_177974_f();
                break;
            }
            case WEST: {
                targetPos = pos.func_177976_e();
                break;
            }
        }
        if (targetPos != null) {
            return world.func_180495_p(targetPos).func_177230_c() instanceof StickPlateBlock;
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(FACING, (Comparable)placer.func_174811_aO()), 2);
        if (this.isLoop(worldIn, pos, 100).booleanValue()) {
            worldIn.func_217377_a(pos, false);
            if (!worldIn.field_72995_K) {
                PlayerEntity player = (PlayerEntity)placer;
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.movepad.loopbuilderror", new Object[0]);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)AABB);
    }
}

