/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.GrassPelt;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Mimicry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.GlobalStatusController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;
import javax.annotation.Nonnull;

public class GrassyTerrain
extends Terrain {
    public GrassyTerrain(boolean extended) {
        super(StatusType.GrassyTerrain, "pixelmon.status.grassyterrain", "pixelmon.status.grassyterrainend", extended);
    }

    public GrassyTerrain(int turnsToGo) {
        super(StatusType.GrassyTerrain, turnsToGo, "pixelmon.status.grassyterrain", "pixelmon.status.grassyterrainend");
    }

    @Override
    public Terrain getNewInstance() {
        return new GrassyTerrain(false);
    }

    @Override
    @Nonnull
    public com.pixelmonmod.pixelmon.api.battles.Terrain getTerrainType() {
        return com.pixelmonmod.pixelmon.api.battles.Terrain.GRASSY;
    }

    @Override
    public Element getTypingForTerrain() {
        return Element.GRASS;
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (this.affectsPokemon(user) && a.getType() == Element.GRASS) {
            power = (int)((double)power * 1.3);
        }
        if (a.isAttack(AttackRegistry.BULLDOZE, AttackRegistry.EARTHQUAKE, AttackRegistry.MAGNITUDE)) {
            power = (int)((double)power * 0.5);
        }
        return new int[]{power, accuracy};
    }

    @Override
    public void applyRepeatedEffect(GlobalStatusController gsc) {
        super.applyRepeatedEffect(gsc);
        if (gsc.hasStatus(this.type)) {
            for (PixelmonWrapper p : gsc.bc.getDefaultTurnOrder()) {
                if (p.hasFullHealth() || p.isFainted() || p.isAirborne() || p.hasStatus(StatusType.HealBlock) || p.healByPercent(6.25f) <= 0) continue;
                p.bc.sendToAll("pixelmon.effect.restorehealth", p.getNickname());
            }
        }
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        int benefits = 0;
        List<Attack> moveset = user.getBattleAI().getMoveset(target);
        if (this.affectsPokemon(target)) {
            if (Attack.hasOffensiveAttackType(moveset, Element.GRASS)) {
                ++benefits;
            }
            for (Attack move : moveset) {
                if (!move.isAttack(AttackRegistry.NATURE_POWER) && !move.isAttack(AttackRegistry.SECRET_POWER) && !move.isAttack(AttackRegistry.CAMOUFLAGE) && !move.isAttack(AttackRegistry.GRASSY_GLIDE) && !move.isAttack(AttackRegistry.TERRAIN_PULSE) && !move.isAttack(AttackRegistry.FLORAL_HEALING)) continue;
                ++benefits;
            }
            if (target.getBattleAbility().isAbility((Class<? extends AbstractAbility>)GrassPelt.class)) {
                ++benefits;
            }
            if (target.getBattleAbility().isAbility((Class<? extends AbstractAbility>)Mimicry.class)) {
                ++benefits;
            }
            if (target.hasHeldItem() && target.getHeldItem().getHeldItemType() == EnumHeldItems.terrainExtender || target.getHeldItem().getHeldItemType() == EnumHeldItems.terrainSeed) {
                ++benefits;
            }
            ++benefits;
        }
        if (Attack.hasAttack(moveset, AttackRegistry.BULLDOZE, AttackRegistry.EARTHQUAKE, AttackRegistry.MAGNITUDE)) {
            --benefits;
        }
        return benefits;
    }

    @Override
    public StatusBase copy() {
        return new GrassyTerrain(this.turnsToGo);
    }
}

