/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.List;
import net.minecraft.util.text.TranslationTextComponent;

public class Encore
extends StatusBase {
    transient Attack attack;
    transient int turns;

    public Encore() {
        super(StatusType.Encore);
    }

    public Encore(Attack attack) {
        super(StatusType.Encore);
        this.attack = attack;
        this.turns = 3;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        Attack lastAttack = target.lastAttack;
        if (target.isDynamax()) {
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
            return;
        }
        TranslationTextComponent message = ChatHandler.getMessage("pixelmon.status.encore", target.getNickname());
        if (lastAttack == null || lastAttack.pp <= 0 || lastAttack.isAttack(AttackRegistry.ENCORE, AttackRegistry.MIMIC, AttackRegistry.MIRROR_MOVE, AttackRegistry.SKETCH, AttackRegistry.STRUGGLE, AttackRegistry.TRANSFORM) || !target.addStatus(new Encore(lastAttack), target, message)) {
            if (target.hasStatus(StatusType.Disable)) {
                user.attack.moveResult.result = AttackResult.failed;
            }
            target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (!user.attack.equals(this.attack) && !a.isAttack(AttackRegistry.STRUGGLE)) {
            user.attack = this.attack;
            user.targets = user.getTargets(this.attack);
        }
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (this.turns <= 0) {
            pw.bc.sendToAll("pixelmon.status.encoreend", pw.getNickname());
            pw.removeStatus(this);
            return;
        }
        for (Attack attack : pw.getMoveset()) {
            if (attack == null || attack.equals(this.attack)) continue;
            attack.setDisabled(true, pw);
        }
    }

    @Override
    public void onEndOfTurn(PixelmonWrapper pw) {
        --this.turns;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper target : userChoice.targets) {
            if (target.isDynamax != 0 || target.hasStatus(StatusType.Encore) || MoveChoice.canOutspeed(bestOpponentChoices, pw, userChoice.createList()) || target.lastAttack == null || target.lastAttack.getAttackCategory() != AttackCategory.STATUS) continue;
            userChoice.raiseWeight(100.0f);
        }
    }
}

