/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.FlareBoost;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Guts;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Heatproof;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MarvelScale;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.QuickFeet;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Synchronize;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TranslationTextComponent;

public class Burn
extends StatusPersist {
    private static final transient float AI_WEIGHT = 25.0f;

    public Burn() {
        super(StatusType.Burn);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance()) {
            Burn.burn(user, target, user.attack, true);
        }
    }

    public static boolean burn(PixelmonWrapper user, PixelmonWrapper target, Attack attack, boolean showMessage) {
        boolean result;
        boolean isStatusMove;
        boolean bl = isStatusMove = attack != null && attack.getAttackCategory() == AttackCategory.STATUS;
        if (target.hasType(Element.FIRE)) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
                user.setAttackFailed();
            }
            return false;
        }
        if (target.hasNonVolatileStatus()) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                user.setAttackFailed();
            }
            return false;
        }
        TranslationTextComponent message = null;
        if (showMessage) {
            message = ChatHandler.getMessage("pixelmon.effect.burnt", target.getNickname());
        }
        if (!(result = target.addStatus(new Burn(), user, message)) && isStatusMove) {
            user.setAttackFailed();
        }
        return result;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        Ability userAbility = pw.getBattleAbility();
        if (!(userAbility instanceof MagicGuard)) {
            pw.bc.sendToAll("pixelmon.status.burnhurt", pw.getNickname());
            int fraction = userAbility instanceof Heatproof ? 32 : 16;
            pw.doBattleDamage(pw, pw.getPercentMaxHealth(100.0f / (float)fraction), DamageTypeEnum.STATUS);
        }
    }

    @Override
    public StatusPersist restoreFromNBT(CompoundNBT nbt) {
        return new Burn();
    }

    @Override
    public int[] modifyPowerAndAccuracyUser(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack attack) {
        if (!user.getBattleAbility().isAbility((Class<? extends AbstractAbility>)Guts.class) && !attack.isAttack(AttackRegistry.FACADE) && attack.getAttackCategory() == AttackCategory.PHYSICAL) {
            return new int[]{(int)Math.ceil((float)power / 2.0f), accuracy};
        }
        return new int[]{power, accuracy};
    }

    @Override
    public boolean isImmune(PixelmonWrapper pokemon) {
        return pokemon.hasType(Element.FIRE);
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.burncure";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.burncureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        boolean offensive = userChoice.isOffensiveMove();
        float weight = this.getWeightWithChance(25.0f);
        if (!offensive || userChoice.isMiddleTier()) {
            boolean hitsAlly = userChoice.hitsAlly();
            if (offensive && hitsAlly) {
                return;
            }
            ArrayList<PixelmonWrapper> opponents = pw.getOpponentPokemon();
            for (PixelmonWrapper target : userChoice.targets) {
                boolean beneficial;
                if (offensive && !Burn.burn(pw, target, userChoice.attack, false)) continue;
                Ability ability = target.getBattleAbility();
                boolean bl = beneficial = ability instanceof FlareBoost || ability instanceof Guts || ability instanceof MarvelScale || ability instanceof QuickFeet;
                if (beneficial && hitsAlly) {
                    if (!(ability instanceof Guts) && target.getMoveset().hasAttackCategory(AttackCategory.PHYSICAL)) continue;
                    userChoice.raiseWeight(weight);
                    continue;
                }
                if (beneficial ^ hitsAlly) {
                    userChoice.raiseWeight(-weight);
                    continue;
                }
                if (ability instanceof Synchronize) continue;
                pw.getBattleAI().weightStatusOpponentOptions(pw, userChoice, target, new Burn(), opponents, bestOpponentChoices);
                if (ability instanceof MagicGuard) continue;
                userChoice.raiseWeight(weight);
            }
        }
    }
}

