/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.log.action.type;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.log.action.BattleAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.StringJoiner;

public class StatChangeAction
extends BattleAction {
    protected final int[] oldStats;
    protected final int[] newStats;
    protected final String pokemonName;

    public StatChangeAction(int turn, PixelmonWrapper pokemon, int[] oldStats, int[] newStats) {
        super(turn);
        this.pokemonName = pokemon.getPokemonName();
        this.oldStats = oldStats;
        this.newStats = newStats;
    }

    @Override
    public boolean appendLog(StringBuilder builder) {
        StringJoiner joiner = new StringJoiner(", ");
        boolean changed = false;
        for (int i = 0; i < this.oldStats.length; ++i) {
            int newStat = this.newStats[i];
            int oldStat = this.oldStats[i];
            if (newStat == oldStat) continue;
            changed = true;
            joiner.add(BattleStatsType.fromIndex(i) + "=" + (oldStat - newStat));
        }
        if (!changed) {
            return false;
        }
        builder.append(this.pokemonName).append(" stats changed from ");
        builder.append("[").append(this.formatBattleStats(this.oldStats)).append("]").append(" to ");
        builder.append("[").append(this.formatBattleStats(this.newStats)).append("]");
        builder.append(" delta: ");
        builder.append(joiner);
        return true;
    }

    private String formatBattleStats(int[] stats) {
        StringJoiner joiner = new StringJoiner(", ");
        for (int i = 0; i < stats.length; ++i) {
            int stat = stats[i];
            joiner.add(BattleStatsType.fromIndex(i) + "=" + stat);
        }
        return joiner.toString();
    }
}

