/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Levitate;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.SmackedDown;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class SmackDown
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (!user.attack.isAttack(AttackRegistry.THOUSAND_ARROWS)) {
            if (target.hasStatus(StatusType.Substitute)) {
                return AttackResult.proceed;
            }
            if (target.hasStatus(StatusType.Flying)) {
                target.canAttack = false;
            }
            if (target.removeStatuses(StatusType.Flying, StatusType.MagnetRise, StatusType.Telekinesis) || !target.hasStatus(StatusType.SmackedDown) && (target.hasType(Element.FLYING) || target.getBattleAbility() instanceof Levitate)) {
                user.bc.sendToAll("pixelmon.effect.smackdown", target.getNickname());
            }
            target.addStatus(new SmackedDown(), user);
        }
        return AttackResult.proceed;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.attack.isAttack(AttackRegistry.THOUSAND_ARROWS) && target.hasType(Element.FLYING)) {
            if (target.hasStatus(StatusType.Substitute)) {
                return;
            }
            if (target.hasStatus(StatusType.Flying)) {
                target.canAttack = false;
            }
            if (target.removeStatuses(StatusType.Flying, StatusType.MagnetRise, StatusType.Telekinesis) || !target.hasStatus(StatusType.SmackedDown) && (target.hasType(Element.FLYING) || target.getBattleAbility() instanceof Levitate)) {
                user.bc.sendToAll("pixelmon.effect.smackdown", target.getNickname());
            }
            target.addStatus(new SmackedDown(), user);
        }
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            if (target.hasStatus(StatusType.Flying) && pw.bc.getFirstMover(pw, target) == pw) {
                userChoice.raiseWeight(50.0f);
            }
            if (!target.isAirborne() || !pw.getMoveset().hasOffensiveAttackType(Element.GROUND)) continue;
            userChoice.raiseWeight(25.0f);
        }
    }
}

