/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Assist
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.getParticipant().allPokemon.length == 1) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        ArrayList<Attack> possibleAttacks = this.getPossibleAttacks(user);
        if (!possibleAttacks.isEmpty()) {
            user.useTempAttack(RandomHelper.getRandomElementFromList(possibleAttacks));
            return AttackResult.ignore;
        }
        user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        return AttackResult.failed;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        ArrayList<Attack> possibleAttacks = this.getPossibleAttacks(pw);
        if (possibleAttacks.isEmpty()) {
            return;
        }
        List<MoveChoice> possibleChoices = MoveChoice.createMoveChoicesFromList(possibleAttacks, pw);
        pw.getBattleAI().weightRandomMove(pw, userChoice, possibleChoices);
    }

    private ArrayList<Attack> getPossibleAttacks(PixelmonWrapper user) {
        ArrayList<Attack> possibleAttacks = new ArrayList<Attack>();
        for (PixelmonWrapper other : user.getParticipant().allPokemon) {
            if (other == user) continue;
            possibleAttacks.addAll(other.getMoveset().stream().filter(attack -> attack != null && !attack.isAttack(AttackRegistry.ASSIST, AttackRegistry.BANEFUL_BUNKER, AttackRegistry.BELCH, AttackRegistry.BESTOW, AttackRegistry.BOUNCE, AttackRegistry.CELEBRATE, AttackRegistry.CHATTER, AttackRegistry.CIRCLE_THROW, AttackRegistry.COPYCAT, AttackRegistry.COUNTER, AttackRegistry.COVET, AttackRegistry.DESTINY_BOND, AttackRegistry.DETECT, AttackRegistry.DIG, AttackRegistry.DIVE, AttackRegistry.DRAGON_TAIL, AttackRegistry.ENDURE, AttackRegistry.COPYCAT, AttackRegistry.COUNTER, AttackRegistry.COVET, AttackRegistry.DESTINY_BOND, AttackRegistry.DETECT, AttackRegistry.DIG, AttackRegistry.DIVE, AttackRegistry.DRAGON_TAIL, AttackRegistry.ENDURE, AttackRegistry.FEINT, AttackRegistry.FLY, AttackRegistry.FOCUS_PUNCH, AttackRegistry.FOLLOW_ME, AttackRegistry.HELPING_HAND, AttackRegistry.HOLD_HANDS, AttackRegistry.KINGS_SHIELD, AttackRegistry.MAT_BLOCK, AttackRegistry.ME_FIRST, AttackRegistry.METRONOME, AttackRegistry.MIMIC, AttackRegistry.MIRROR_COAT, AttackRegistry.MIRROR_MOVE, AttackRegistry.NATURE_POWER, AttackRegistry.PHANTOM_FORCE, AttackRegistry.PROTECT, AttackRegistry.RAGE_POWDER, AttackRegistry.ROAR, AttackRegistry.SHADOW_FORCE, AttackRegistry.SHELL_TRAP, AttackRegistry.SKETCH, AttackRegistry.SKY_DROP, AttackRegistry.SLEEP_TALK, AttackRegistry.SNATCH, AttackRegistry.SPIKY_SHIELD, AttackRegistry.SPOTLIGHT, AttackRegistry.STRUGGLE, AttackRegistry.SWITCHEROO, AttackRegistry.THIEF, AttackRegistry.TRANSFORM, AttackRegistry.TRICK, AttackRegistry.WHIRLWIND)).collect(Collectors.toList()));
        }
        return possibleAttacks;
    }
}

