/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.List;

public abstract class AddType
extends SpecialAttackBase {
    public Element type;

    public AddType(Element type) {
        this.type = type;
    }

    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.hasType(this.type)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        List<Element> newType = this.getNewType(target);
        if (!user.bc.simulateMode) {
            target.addedType = this.type;
        }
        target.setTempType(newType);
        user.bc.sendToAll("pixelmon.effect.addtype", this.type.getLocalizedName(), target.getNickname());
        return AttackResult.succeeded;
    }

    private List<Element> getNewType(PixelmonWrapper target) {
        ArrayList<Element> newType = new ArrayList<Element>();
        newType.addAll(target.type);
        newType.add(this.type);
        if (target.addedType != null && target.addedType != this.type) {
            newType.remove(target.addedType);
        }
        return newType;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper target : userChoice.targets) {
            pw.getBattleAI().weightSingleTypeChange(pw, userChoice, this.getNewType(target), target, bestUserChoices, bestOpponentChoices);
        }
    }
}

