/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class TargetPoint {
    private RegistryKey<World> dimension;
    private double x;
    private double y;
    private double z;
    private double radius;

    public TargetPoint(RegistryKey<World> dimension, double x, double y, double z, double radius) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
    }

    public TargetPoint(World world, BlockPos pos, double radius) {
        this.dimension = world.func_234923_W_();
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.radius = radius;
    }

    public TargetPoint() {
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getRadius() {
        return this.radius;
    }

    public PacketDistributor.TargetPoint toMojang() {
        return new PacketDistributor.TargetPoint(this.x, this.y, this.z, this.radius, this.dimension);
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeDouble(this.radius);
        buffer.func_192572_a(this.dimension.func_240901_a_());
    }

    public void decode(PacketBuffer buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.dimension = DimensionHelper.getDimension(buffer.func_192575_l());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetPoint)) {
            return false;
        }
        TargetPoint that = (TargetPoint)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && Double.compare(that.radius, this.radius) == 0 && Objects.equals(this.dimension, that.dimension);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.x, this.y, this.z, this.radius);
    }
}

