/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.trading;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.npc.NPCTraderEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.SetClientTradePairPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.eventbus.api.Event;

public class NPCTrades {
    private static final HashMap<UUID, TradePair> activeTrades = new HashMap();

    public static void updateClientTradeData(ServerPlayerEntity player, TradePair tradePair) {
        boolean hasPokemon = false;
        PlayerPartyStorage party = StorageProxy.getParty(player);
        for (Pokemon pokemon : party.getTeam()) {
            if (pokemon == null || !tradePair.exchange.matches(pokemon) || pokemon.isUntradeable()) continue;
            hasPokemon = true;
            party.retrieveAll("EntityInteract");
            break;
        }
        NetworkHelper.sendPacket(new SetClientTradePairPacket(tradePair, hasPokemon), player);
    }

    public static void showTrade(ServerPlayerEntity player, TradePair tradePair) {
        NPCTrades.showTrade(player, tradePair, -1);
    }

    public static void showTrade(ServerPlayerEntity player, TradePair tradePair, int trainerID) {
        NPCTraderEvent.ShowTrade.Pre pre = new NPCTraderEvent.ShowTrade.Pre((PlayerEntity)player, (NPCEntity)player.field_70170_p.func_73045_a(trainerID), tradePair);
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            return;
        }
        NPCTrades.updateClientTradeData(player, pre.getTrade());
        activeTrades.put(player.func_110124_au(), pre.getTrade());
        OpenScreenPacket.open((PlayerEntity)player, EnumGuiScreen.NPCTraderGui, trainerID);
        Pixelmon.EVENT_BUS.post((Event)new NPCTraderEvent.ShowTrade.Post((PlayerEntity)player, pre.getTrader(), pre.getTrade()));
    }

    @Nullable
    public static TradePair getTradePair(UUID uuid) {
        return activeTrades.get(uuid);
    }

    public static void clearTradePair(UUID uuid) {
        activeTrades.remove(uuid);
    }
}

