/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners;

import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;

public class TriggerSpawner
extends AbstractSpawner {
    public float triggerChance;

    public TriggerSpawner(String name) {
        this(name, 1.0f);
    }

    public TriggerSpawner(String name, float triggerChance) {
        super(name);
        this.triggerChance = triggerChance;
    }

    @Nullable
    public Entity trigger(SpawnLocation location) {
        SpawnInfo spawnInfo;
        if (RandomHelper.getRandomChance(this.triggerChance) && (spawnInfo = this.getWeightedSpawnInfo(location)) != null) {
            return spawnInfo.construct(this, location).doSpawn(this);
        }
        return null;
    }

    public SpawnAction<? extends Entity> getAction(SpawnLocation location, float triggerChance) {
        SpawnInfo spawnInfo;
        if (RandomHelper.getRandomChance(triggerChance) && (spawnInfo = this.getWeightedSpawnInfo(location)) != null) {
            return spawnInfo.construct(this, location);
        }
        return null;
    }
}

