/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.replacement;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.replacement.ReplacementDetectionRegistry;
import com.pixelmonmod.pixelmon.api.replacement.ReplacementLogicRegistry;
import com.pixelmonmod.pixelmon.api.replacement.SpawnDetectionLogic;
import com.pixelmonmod.pixelmon.api.replacement.SpawnReplacementLogic;
import com.pixelmonmod.pixelmon.api.replacement.replacement.SpawnReplacement;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class SpawnReplacementRegistry {
    private static final List<SpawnReplacement> SPAWN_REPLACEMENTS = Lists.newArrayList();

    public static void register(Gson gson, ResourceLocation rl, JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject();
        boolean enabled = jsonObject.get("enabled").getAsBoolean();
        SpawnDetectionLogic detection = null;
        if (jsonObject.has("detection_logic")) {
            detection = ReplacementDetectionRegistry.get(jsonObject.get("detection_logic").getAsString()).orElse(null);
            if (detection != null) {
                detection.read(gson, (JsonElement)jsonObject);
            } else {
                Pixelmon.LOGGER.error("Unknown detection logic type: `" + jsonObject.get("detection_logic").getAsString() + "` in file: " + rl.toString());
            }
        }
        SpawnReplacementLogic replacement = null;
        if (jsonObject.has("replacement_logic")) {
            replacement = ReplacementLogicRegistry.get(jsonObject.get("replacement_logic").getAsString()).orElse(null);
            if (replacement != null) {
                replacement.read(gson, (JsonElement)jsonObject);
            } else {
                Pixelmon.LOGGER.error("Unknown replacement logic type: `" + jsonObject.get("replacement_logic").getAsString() + "` in file: " + rl.toString());
            }
        }
        SPAWN_REPLACEMENTS.add(new SpawnReplacement(enabled, detection, replacement));
    }

    public static void register(SpawnReplacement replacement) {
        SPAWN_REPLACEMENTS.add(replacement);
    }

    public static void reset() {
        SPAWN_REPLACEMENTS.clear();
    }

    public static void handleEvent(EntityJoinWorldEvent event) {
        for (SpawnReplacement spawnReplacement : SPAWN_REPLACEMENTS) {
            if (spawnReplacement == null) continue;
            spawnReplacement.replace(event);
        }
    }
}

