/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.api.util.helpers.BiomeHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.biome.Biome;

public class BiomeCondition
extends EvoCondition {
    public ArrayList<String> biomes = new ArrayList();

    public BiomeCondition() {
        super("biome");
    }

    public BiomeCondition(Biome ... biomes) {
        this();
        for (Biome biome : biomes) {
            this.biomes.add(biome.getRegistryName().toString());
        }
    }

    public BiomeCondition(ArrayList<Biome> biomes) {
        this();
        biomes.forEach(b -> this.biomes.add(b.getRegistryName().toString()));
    }

    @Override
    public boolean passes(PixelmonEntity pixelmon) {
        ResourceLocation biome = pixelmon.getOwner() != null ? pixelmon.getOwner().func_130014_f_().func_226691_t_(pixelmon.getOwner().func_233580_cy_()).getRegistryName() : pixelmon.func_130014_f_().func_226691_t_(pixelmon.func_233580_cy_()).getRegistryName();
        if (biome != null) {
            return this.biomes.contains(biome.toString()) || this.biomes.contains(biome.func_110623_a());
        }
        return false;
    }

    @Override
    public IFormattableTextComponent getDescription() {
        List<ITextComponent> biomes = this.biomes.stream().map(it -> {
            ResourceLocation resource = new ResourceLocation(it);
            return BiomeHelper.getLocalizedBiomeName(resource);
        }).collect(Collectors.toList());
        return PixelmonCommandUtils.format("pixelmon.evolution.conditions.biome", TextHelper.join(biomes, (ITextComponent)TextHelper.OR_DELIMITER));
    }
}

