/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.item.pokeball;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureMethod;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureMethodRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.logic.BallLogic;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.pixelmonmod.pixelmon.items.PokeBallLidItem;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class PokeBall
implements ITranslatable {
    private static final BallLogic DEFAULT_LOGIC = new BallLogic(){};
    private final String name;
    private final String model;
    private final ResourceWithFallback texture;
    private final ResourceWithFallback flashingTexture;
    private final ResourceWithFallback ballSprite;
    private final ResourceWithFallback lidSprite;
    private final ResourceWithFallback guiSprite;
    private final BallLogic logic;
    private final String[] bases;
    private final CaptureMethod captureMethod;
    private final double catchBonus;
    private final double breakChance;
    private final double velocityModifier;
    private final double gravityModifier;
    private final boolean particles;
    private final boolean hasLid;
    private transient Set<Item> basesItems = null;
    private final transient String json;
    private final transient String captureMethodID;
    private final transient String logicPath;
    @OnlyIn(value=Dist.CLIENT)
    private transient GenericModelHolder<ModelPokeballs> modelHolder;
    @OnlyIn(value=Dist.CLIENT)
    private transient GenericModelHolder<ModelPokeballs> modelHolderNoAnim;

    public PokeBall(String name, String model, ResourceWithFallback texture, ResourceWithFallback flashingTexture, ResourceWithFallback ballSprite, ResourceWithFallback lidSprite, ResourceWithFallback guiSprite, String logic, String[] bases, String captureMethod, double catchBonus, double breakChance, double velocityModifier, double gravityModifier, boolean particles, boolean hasLid, String json) {
        this.name = name;
        this.model = model;
        this.texture = texture;
        this.flashingTexture = flashingTexture;
        this.ballSprite = ballSprite;
        this.lidSprite = lidSprite;
        this.guiSprite = guiSprite;
        this.logic = this.getNewLogicInstance(logic);
        this.logicPath = logic;
        this.bases = bases;
        this.captureMethod = CaptureMethodRegistry.getCaptureMethod(captureMethod);
        this.catchBonus = catchBonus;
        this.breakChance = breakChance;
        this.velocityModifier = velocityModifier;
        this.gravityModifier = gravityModifier;
        this.particles = particles;
        this.hasLid = hasLid;
        this.json = json;
        this.captureMethodID = captureMethod;
    }

    public String getName() {
        return this.name;
    }

    public String getModel() {
        return this.model;
    }

    public ResourceLocation getBallSprite() {
        return this.ballSprite.get();
    }

    public ResourceLocation getLidSprite() {
        if (this.lidSprite == null) {
            return new ResourceLocation("");
        }
        return this.lidSprite.get();
    }

    public ResourceLocation getModelTexture() {
        return this.texture.get();
    }

    public ResourceLocation getFlashingTexture() {
        return this.flashingTexture.get();
    }

    public ResourceLocation getGUISprite() {
        return this.guiSprite.get();
    }

    public BallLogic getLogic() {
        return this.logic;
    }

    public String[] getBases() {
        return this.bases;
    }

    public CaptureMethod getCaptureMethod() {
        return this.captureMethod;
    }

    public double getCatchBonus() {
        return this.catchBonus;
    }

    public boolean isGuaranteedCatch() {
        return this.getCatchBonus() >= 255.0;
    }

    public double getBreakChance() {
        return this.breakChance;
    }

    public double getVelocityModifier() {
        return this.velocityModifier;
    }

    public double getGravityModifier() {
        return this.gravityModifier;
    }

    public boolean hasParticles() {
        return this.particles;
    }

    @Override
    public String getTranslationKey() {
        return "item.pixelmon." + this.name + "";
    }

    public String getLidTranslationKey() {
        return this.getTranslationKey() + "_lid";
    }

    public boolean hasLid() {
        return this.hasLid;
    }

    public TranslationTextComponent getTranslatedLidName() {
        return new TranslationTextComponent(this.getLidTranslationKey());
    }

    public boolean is(PokeBall ... pokeballs) {
        for (PokeBall pokeball : pokeballs) {
            if (this != pokeball) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean is(RegistryValue<PokeBall> ... pokeballs) {
        for (RegistryValue<PokeBall> pokeball : pokeballs) {
            if (!pokeball.isInitialized() || this != pokeball.getValueUnsafe()) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public GenericModelHolder<ModelPokeballs> getModelHolder() {
        return this.getModelHolder(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public GenericModelHolder<ModelPokeballs> getModelHolder(boolean animate) {
        if (animate) {
            if (this.modelHolder == null) {
                this.modelHolder = new GenericModelHolder<ModelPokeballs>(ModelPokeballs.class, this.getModel());
            }
            return this.modelHolder;
        }
        if (this.modelHolderNoAnim == null) {
            this.modelHolderNoAnim = new GenericModelHolder<ModelPokeballs>(ModelPokeballs.class, this.getModel());
        }
        return this.modelHolderNoAnim;
    }

    private BallLogic getNewLogicInstance(String clazz) {
        if (!Pixelmon.isClient() && clazz != null && !clazz.isEmpty()) {
            try {
                return (BallLogic)Class.forName(clazz).newInstance();
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Failed to instantiate CaptureLogic " + clazz + " in PokeBall " + this.getName() + ". Falling back to default.");
                return DEFAULT_LOGIC;
            }
        }
        return DEFAULT_LOGIC;
    }

    public ItemStack getBallItem() {
        return this.getBallItem(1);
    }

    public ItemStack getBallItem(int count) {
        return PokeBallItem.of(this, count);
    }

    public Set<Item> getBasesAsItems() {
        if (this.basesItems == null) {
            this.basesItems = Sets.newHashSet();
            for (String base : this.bases) {
                this.basesItems.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("pixelmon", base + "_base")));
            }
        }
        return this.basesItems;
    }

    public Item getRandomBaseAsItem() {
        return RandomHelper.getRandomElementFromCollection(this.getBasesAsItems());
    }

    public ItemStack getLidItem() {
        return this.getLidItem(1);
    }

    public ItemStack getLidItem(int count) {
        return PokeBallLidItem.of(this, count);
    }

    public String getJson() {
        return this.json;
    }

    public String getLogicPath() {
        return this.logicPath;
    }

    public String getCaptureMethodID() {
        return this.captureMethodID;
    }

    public boolean isHisuian() {
        return this.is(PokeBallRegistry.ANCIENT_POKE_BALL, PokeBallRegistry.ANCIENT_GREAT_BALL, PokeBallRegistry.ANCIENT_HEAVY_BALL, PokeBallRegistry.ANCIENT_ULTRA_BALL, PokeBallRegistry.LEADEN_BALL, PokeBallRegistry.FEATHER_BALL, PokeBallRegistry.WING_BALL, PokeBallRegistry.JET_BALL, PokeBallRegistry.ORIGIN_BALL, PokeBallRegistry.GIGATON_BALL);
    }

    public String toString() {
        return "PokeBall{" + this.getName() + "}";
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PokeBall)) {
            return false;
        }
        return ((PokeBall)obj).getName().equalsIgnoreCase(this.getName());
    }
}

