/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public abstract class OfRuin
extends AbstractAbility {
    private final BattleStatsType stat;

    public OfRuin(BattleStatsType stat) {
        this.stat = stat;
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        newPokemon.bc.sendToAll("pixelmon.abilities.ofruin", newPokemon.getNickname(), this.getLocalizedName(), this.stat.getTranslatedName());
    }

    @Override
    public int[] modifyStatsCancellableOther(PixelmonWrapper user, PixelmonWrapper target, int[] stats) {
        if (target.getBattleAbility().equals(user.getBattleAbility())) {
            return stats;
        }
        BattleStatsType statTypeUsed = this.stat;
        if (user.bc.globalStatusController.hasStatus(StatusType.WonderRoom)) {
            if (this.stat == BattleStatsType.DEFENSE) {
                statTypeUsed = BattleStatsType.SPECIAL_DEFENSE;
            }
            if (this.stat == BattleStatsType.SPECIAL_DEFENSE) {
                statTypeUsed = BattleStatsType.DEFENSE;
            }
        }
        int n = statTypeUsed.getStatIndex();
        stats[n] = (int)((double)stats[n] * 0.75);
        return stats;
    }
}

