/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.dialogue;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.dialogue.Choice;
import com.pixelmonmod.pixelmon.api.events.dialogue.DialogueChoiceEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue.SetDialogueDataPacket;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;

public class Dialogue {
    public final String name;
    private final String text;
    private final String localizedText;
    public final ArrayList<Choice> choices;
    private final boolean escapeCloses;
    public QuestProgressClient quest = null;

    @Deprecated
    public Dialogue(PacketBuffer buffer) {
        this(buffer, false);
    }

    @Deprecated
    public Dialogue(PacketBuffer buffer, boolean localized) {
        this.escapeCloses = buffer.readBoolean();
        String name = buffer.func_218666_n();
        String string = this.name = localized ? I18n.func_135052_a((String)name, (Object[])new Object[0]) : name;
        if (buffer.readBoolean() || localized) {
            this.text = null;
            this.localizedText = buffer.func_218666_n();
        } else {
            this.text = buffer.func_218666_n();
            this.localizedText = null;
        }
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (byte choiceCount = buffer.readByte(); choiceCount > 0; choiceCount = (byte)(choiceCount - 1)) {
            choices.add(new Choice(buffer, localized));
        }
        this.choices = choices;
    }

    public Dialogue(PacketBuffer buffer, UUID quest) {
        this.escapeCloses = buffer.readBoolean();
        if (quest == null) {
            this.name = buffer.func_218666_n();
            if (buffer.readBoolean()) {
                this.localizedText = buffer.func_218666_n();
                this.text = null;
            } else {
                this.localizedText = null;
                this.text = buffer.func_218666_n();
            }
        } else {
            this.quest = QuestDataClient.getInstance().get(quest);
            this.name = this.quest.format(buffer.func_218666_n());
            buffer.readBoolean();
            this.text = this.quest.format(buffer.func_218666_n());
            this.localizedText = null;
        }
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (byte choiceCount = buffer.readByte(); choiceCount > 0; choiceCount = (byte)(choiceCount - 1)) {
            choices.add(new Choice(buffer, true));
        }
        this.choices = choices;
    }

    public Dialogue(String name, String text, String localizedText, boolean escapeCloses, ArrayList<Choice> choices) {
        this.name = name;
        this.text = text;
        this.escapeCloses = escapeCloses;
        this.localizedText = localizedText;
        this.choices = choices == null ? new ArrayList() : choices;
    }

    @Deprecated
    public void writeToBytes(PacketBuffer buffer) {
        buffer.writeBoolean(this.escapeCloses);
        buffer.func_180714_a(this.name);
        buffer.writeBoolean(this.text == null);
        if (this.text == null) {
            buffer.func_180714_a(this.localizedText);
        } else {
            buffer.func_180714_a(this.text);
        }
        buffer.writeByte(this.choices.size());
        for (Choice choice : this.choices) {
            choice.toBytes(buffer);
        }
    }

    public String getText() {
        return this.text == null ? (I18n.func_188566_a((String)this.localizedText) ? I18n.func_135052_a((String)this.localizedText, (Object[])new Object[0]) : this.localizedText) : this.text;
    }

    public void open(ServerPlayerEntity ... players) {
        this.open((UUID)null, players);
    }

    public void open(UUID quest, ServerPlayerEntity ... players) {
        for (ServerPlayerEntity player : players) {
            Dialogue.setPlayerDialogueData(quest, player, Lists.newArrayList((Object[])new Dialogue[]{this}), true);
        }
    }

    public boolean escapeCloses() {
        return this.escapeCloses;
    }

    public static void setPlayerDialogueData(ServerPlayerEntity player, List<Dialogue> dialogues, boolean openGui) {
        Dialogue.setPlayerDialogueData(null, player, dialogues, openGui);
    }

    public static void setPlayerDialogueData(UUID quest, ServerPlayerEntity player, List<Dialogue> dialogues, boolean openGui) {
        HashMap<Integer, Consumer<DialogueChoiceEvent>> choiceMap = new HashMap<Integer, Consumer<DialogueChoiceEvent>>();
        for (Dialogue dialogue : dialogues) {
            for (Choice choice : dialogue.choices) {
                choiceMap.put(choice.choiceID, choice.handle);
            }
        }
        Choice.handleMap.put(player.func_110124_au(), choiceMap);
        NetworkHelper.sendPacket(player, new SetDialogueDataPacket(dialogues, openGui, quest));
    }

    public static DialogueBuilder builder() {
        return new DialogueBuilder();
    }

    public static class DialogueBuilder {
        private String name = "";
        private String text = null;
        private String localizedText = null;
        private ArrayList<Choice> choices = new ArrayList();
        private boolean escapeCloses = true;

        public Dialogue build() {
            return new Dialogue(this.name, this.text, this.localizedText, this.escapeCloses, this.choices);
        }

        public DialogueBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public DialogueBuilder setText(String text) {
            this.text = text;
            return this;
        }

        @Deprecated
        public DialogueBuilder setLocalizedText(String localizedText) {
            if (this.text != null) {
                throw new IllegalStateException("You must use setText()");
            }
            this.localizedText = localizedText;
            return this;
        }

        public DialogueBuilder addChoice(Choice choice) {
            this.choices.add(choice);
            return this;
        }

        public DialogueBuilder setChoices(ArrayList<Choice> choices) {
            this.choices = choices;
            return this;
        }

        public DialogueBuilder injectHandler(Consumer<DialogueChoiceEvent> handle) {
            ArrayList<Choice> newChoices = new ArrayList<Choice>();
            for (Choice choice : this.choices) {
                newChoices.add(Choice.builder().setText(choice.text).setHandle(handle).build(choice.choiceID));
            }
            this.setChoices(newChoices);
            return this;
        }

        public DialogueBuilder escapeCloses() {
            this.escapeCloses = true;
            return this;
        }

        public DialogueBuilder requireManualClose() {
            this.escapeCloses = false;
            return this;
        }

        public void open(ServerPlayerEntity ... players) {
            this.build().open(players);
        }
    }
}

