/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.config.EnumPokelootModes;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PokeLootRate;
import com.pixelmonmod.pixelmon.api.config.adapter.PokeLootRateAdapter;
import com.pixelmonmod.pixelmon.api.config.api.data.ConfigPath;
import com.pixelmonmod.pixelmon.api.config.api.data.Serializers;
import com.pixelmonmod.pixelmon.api.config.api.yaml.AbstractYamlConfig;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import info.pixelmon.repack.org.spongepowered.objectmapping.ConfigSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;

@ConfigSerializable
@ConfigPath(value="config/pixelmon/spawning.yml")
@Serializers(value={PokeLootRateAdapter.class})
public class SpawningConfig
extends AbstractYamlConfig {
    private int despawnRadius = 80;
    private float shinyRate = 4096.0f;
    private float ultraSpaceShinyRateMultiplier = 0.5f;
    private float shinyCharmRateMultiplier = 3.0f;
    private float hiddenAbilityRate = 150.0f;
    private float ultraSpaceHiddenAbilityMultiplier = 0.5f;
    private float ultraSpaceHordeSpawnRate = 0.4f;
    private int legendarySpawnTicks = 25000;
    private float legendarySpawnChance = 0.3f;
    private float spawnTicksPlayerMultiplier = 0.01f;
    private boolean spawnLevelsCloserToPlayerLevels = true;
    private boolean spawnLevelsIncreaseInCaves = true;
    private boolean spawnLevelsIncreaseInUltraSpace = true;
    private int caveMaxMultiplier = 4;
    private double ultraSpaceLevelMultiplier = 2.0;
    private double transformToDittoOnCatch = 0.001;
    private double meltanTransformChance = 0.75;
    private int meltanBoxSpawnRate = 300;
    private int meltanBoxSpawnRadius = 15;
    private int meltanBoxInitialScrapsCount = 4;
    private double meltanBoxScrapsMultiplier = 1.8;
    private long meltanBoxOpenDurationMillis = 100000L;
    private long meltanBoxCooldownDurationMillis = 3000000L;
    private List<String> canTransformToDittoOnCatch = Lists.newArrayList((Object[])new String[]{"Pidgey", "Rattata", "Gastly", "Zubat", "Mankey", "Yanma", "Hoothoot", "Sentret", "Zigzagoon", "Gulpin", "Whismur", "Taillow", "Remoraid", "Starly"});
    private float gigantamaxFactorRate = 512.0f;
    private float ultraSpaceGigantamaxFactorModifier = -1.0f;
    private boolean allowLegendarySpawn = true;
    private int legendaryDespawnTicks = 6000;
    private boolean displayLegendaryGlobalMessage = true;
    private boolean doLegendaryRaidEvent = true;
    private boolean useRecentLevelMoves = false;
    private boolean despawnOnFleeOrLoss = false;
    private double bellSuccessChance = 0.01;
    private int bellInclusionRange = 10;
    private int lureFluteDuration = 180;
    private int lureFluteLevelModifier = 10;
    private List<Integer> blockedGenerations = Lists.newArrayList();
    private boolean spawnZygardeCells = true;
    private int playerTrackingSpawnerSpawnCollectionRate = 100;
    private LevelDistance levelDistance = new LevelDistance();
    private WildSpawning wildSpawning = new WildSpawning();
    private BossSpawning bossSpawning = new BossSpawning();
    private PokeLoot pokeLoot = new PokeLoot();
    private PokeStop pokeStop = new PokeStop();
    private List<String> alwaysAggressiveDimensions = Lists.newArrayList((Object[])new String[]{"pixelmon:ultra_space"});
    private List<String> hordeBattleDimensions = Lists.newArrayList((Object[])new String[]{"pixelmon:ultra_space"});
    private List<String> spawningDisabledDimensions = Lists.newArrayList();

    public int getDespawnRadius() {
        return this.despawnRadius;
    }

    public float getShinyRate() {
        return this.getShinyRate(null);
    }

    public float getShinyCharmMultiplier() {
        return this.shinyCharmRateMultiplier;
    }

    public float getShinyRate(RegistryKey<World> dimension) {
        if (dimension != null && dimension == UltraSpace.WORLD) {
            return this.shinyRate * this.ultraSpaceShinyRateMultiplier;
        }
        return this.shinyRate;
    }

    public int getLegendarySpawnTicks() {
        return this.legendarySpawnTicks;
    }

    public float getLegendarySpawnChance() {
        return this.legendarySpawnChance;
    }

    public float getSpawnTicksPlayerMultiplier() {
        return this.spawnTicksPlayerMultiplier;
    }

    public boolean isSpawnLevelsCloserToPlayerLevels() {
        return this.spawnLevelsCloserToPlayerLevels;
    }

    public boolean isSpawnLevelsIncreaseInCaves() {
        return this.spawnLevelsIncreaseInCaves;
    }

    public int getCaveMaxMultiplier() {
        return this.caveMaxMultiplier;
    }

    public double getUltraSpaceLevelMultiplier() {
        return this.ultraSpaceLevelMultiplier;
    }

    public double getTransformToDittoOnCatch() {
        return this.transformToDittoOnCatch;
    }

    public double getMeltanTransformChance() {
        return this.meltanTransformChance;
    }

    public int getMeltanBoxSpawnRate() {
        return this.meltanBoxSpawnRate;
    }

    public int getMeltanBoxSpawnRadius() {
        return this.meltanBoxSpawnRadius;
    }

    public int getMeltanBoxInitialScrapsCount() {
        return this.meltanBoxInitialScrapsCount;
    }

    public double getMeltanBoxScrapsMultiplier() {
        return this.meltanBoxScrapsMultiplier;
    }

    public long getMeltanBoxOpenDurationMillis() {
        return this.meltanBoxOpenDurationMillis;
    }

    public long getMeltanBoxCooldownDurationMillis() {
        return this.meltanBoxCooldownDurationMillis;
    }

    public List<String> getCanTransformToDittoOnCatch() {
        return this.canTransformToDittoOnCatch;
    }

    @Deprecated
    public float getHiddenAbilityRate() {
        return this.getHiddenAbilityRate(null);
    }

    @Deprecated
    public float getHiddenAbilityRate(RegistryKey<World> dimension) {
        if (dimension != null && dimension == UltraSpace.WORLD) {
            return this.hiddenAbilityRate * this.ultraSpaceHiddenAbilityMultiplier;
        }
        return this.hiddenAbilityRate;
    }

    public boolean shouldHaveHiddenAbility(Stats form, @Nullable RegistryKey<World> dimension) {
        if (!form.getAbilities().hasHiddenAbilities()) {
            return false;
        }
        if (dimension == null || !Objects.equals(dimension, UltraSpace.WORLD)) {
            return this.shouldHaveHiddenAbility(this.hiddenAbilityRate);
        }
        return this.shouldHaveHiddenAbility(this.hiddenAbilityRate * this.ultraSpaceHiddenAbilityMultiplier);
    }

    public boolean shouldHaveHiddenAbility(float rate) {
        return RandomHelper.getRandomChance(1.0f / rate);
    }

    public float getGigantamaxFactorRate() {
        return this.gigantamaxFactorRate;
    }

    public float getGigantamaxFactorRate(RegistryKey<World> dimension) {
        if (dimension != null && dimension == UltraSpace.WORLD) {
            if (this.ultraSpaceGigantamaxFactorModifier == -1.0f) {
                return -1.0f;
            }
            return this.ultraSpaceGigantamaxFactorModifier * this.gigantamaxFactorRate;
        }
        return this.gigantamaxFactorRate;
    }

    public boolean isAllowLegendarySpawn() {
        return this.allowLegendarySpawn;
    }

    public int getLegendaryDespawnTicks() {
        return this.legendaryDespawnTicks;
    }

    public boolean isDisplayLegendaryGlobalMessage() {
        return this.displayLegendaryGlobalMessage;
    }

    public boolean isDoLegendaryRaidEvent() {
        return this.doLegendaryRaidEvent;
    }

    public boolean isUseRecentLevelMoves() {
        return this.useRecentLevelMoves;
    }

    public boolean isDespawnOnFleeOrLoss() {
        return this.despawnOnFleeOrLoss;
    }

    public double getBellSuccessChance() {
        return this.bellSuccessChance;
    }

    public int getBellInclusionRange() {
        return this.bellInclusionRange;
    }

    public int getLureFluteDuration() {
        return this.lureFluteDuration;
    }

    public int getLureFluteLevelModifier() {
        return this.lureFluteLevelModifier;
    }

    public List<Integer> getBlockedGenerations() {
        return this.blockedGenerations;
    }

    public boolean isGenerationEnabled(int generation) {
        return !this.blockedGenerations.contains(generation);
    }

    public boolean allGenerationsDisabled() {
        return this.blockedGenerations.size() == 8;
    }

    public boolean allGenerationsEnabled() {
        return this.blockedGenerations.isEmpty();
    }

    public int getRandomEnabledGeneration() {
        if (PixelmonConfigProxy.getSpawning().allGenerationsEnabled()) {
            return RandomHelper.getRandomNumberBetween(1, 8);
        }
        if (PixelmonConfigProxy.getSpawning().allGenerationsDisabled()) {
            throw new IllegalStateException();
        }
        ArrayList<Integer> generations = new ArrayList<Integer>();
        for (int i = 1; i < 9; ++i) {
            if (!this.isGenerationEnabled(i)) continue;
            generations.add(i);
        }
        return (Integer)generations.get(RandomHelper.getRandomNumberBetween(0, generations.size() - 1));
    }

    public boolean isSpawnZygardeCells() {
        return this.spawnZygardeCells;
    }

    public LevelDistance getLevelDistance() {
        return this.levelDistance;
    }

    public WildSpawning getWildSpawning() {
        return this.wildSpawning;
    }

    public BossSpawning getBossSpawning() {
        return this.bossSpawning;
    }

    public PokeLoot getPokeLoot() {
        return this.pokeLoot;
    }

    public PokeStop getPokeStop() {
        return this.pokeStop;
    }

    public boolean isSpawnLevelsIncreaseInUltraSpace() {
        return this.spawnLevelsIncreaseInUltraSpace;
    }

    public float getUltraSpaceHordeSpawnRate() {
        return this.ultraSpaceHordeSpawnRate;
    }

    public boolean isAlwaysAggressiveDimensions(World world) {
        return this.alwaysAggressiveDimensions.contains(world.func_234923_W_().func_240901_a_().toString());
    }

    public boolean isHordeBattleDimensions(World world) {
        return this.hordeBattleDimensions.contains(world.func_234923_W_().func_240901_a_().toString());
    }

    public boolean isSpawningDisabledDimension(World world) {
        return this.spawningDisabledDimensions.contains(world.func_234923_W_().func_240901_a_().toString());
    }

    public int getPlayerTrackingSpawnerSpawnCollectionRate() {
        return this.playerTrackingSpawnerSpawnCollectionRate;
    }

    @ConfigSerializable
    public static class LevelDistance {
        private boolean spawnLevelsByDistance = false;
        private int maxLevelByDistance = 60;
        private int distancePerLevel = 30;

        public boolean isSpawnLevelsByDistance() {
            return this.spawnLevelsByDistance;
        }

        public int getMaxLevelByDistance() {
            return this.maxLevelByDistance;
        }

        public int getDistancePerLevel() {
            return this.distancePerLevel;
        }
    }

    @ConfigSerializable
    public static class WildSpawning {
        private int entitiesPerPlayer = 30;
        private int spawnsPerPass = 2;
        private float spawnFrequency = 60.0f;
        private float minimumDistanceBetweenSpawns = 15.0f;
        private int minimumDistanceFromCentre = 18;
        private int maximumDistanceFromCentre = 64;
        private float horizontalTrackFactor = 80.0f;
        private float verticalTrackFactor = 0.0f;
        private int horizontalSliceRadius = 10;
        private int verticalSliceRadius = 25;
        private int maximumSpawnedPokemon = 3000;
        private int maximumSpawnedFlyingPokemon = 500;
        private int maximumSpawnedFlyingPokemonPerPlayer = 45;

        public int getEntitiesPerPlayer() {
            return this.entitiesPerPlayer;
        }

        public int getSpawnsPerPass() {
            return this.spawnsPerPass;
        }

        public float getSpawnFrequency() {
            return this.spawnFrequency;
        }

        public float getMinimumDistanceBetweenSpawns() {
            return this.minimumDistanceBetweenSpawns;
        }

        public int getMinimumDistanceFromCentre() {
            return this.minimumDistanceFromCentre;
        }

        public int getMaximumDistanceFromCentre() {
            return this.maximumDistanceFromCentre;
        }

        public float getHorizontalTrackFactor() {
            return this.horizontalTrackFactor;
        }

        public float getVerticalTrackFactor() {
            return this.verticalTrackFactor;
        }

        public int getHorizontalSliceRadius() {
            return this.horizontalSliceRadius;
        }

        public int getVerticalSliceRadius() {
            return this.verticalSliceRadius;
        }

        public int getMaximumSpawnedPokemon() {
            return this.maximumSpawnedPokemon;
        }

        public int getMaximumSpawnedFlyingPokemon() {
            return this.maximumSpawnedFlyingPokemon;
        }

        public int getMaximumSpawnedFlyingPokemonPerPlayer() {
            return this.maximumSpawnedFlyingPokemonPerPlayer;
        }
    }

    @ConfigSerializable
    public static class BossSpawning {
        private float bossRate = 256.0f;
        private float ultraSpaceBossModifier = 0.5f;
        private boolean bossesAlwaysMegaIfPossible = true;
        private int bossSpawnTicks = 10000;
        private float bossSpawnChance = 0.3f;

        public float getBossRate() {
            return this.bossRate;
        }

        public float getBossRate(RegistryKey<World> dimension) {
            if (dimension != null && dimension == UltraSpace.WORLD) {
                return this.bossRate * this.ultraSpaceBossModifier;
            }
            return this.bossRate;
        }

        public boolean isBossesAlwaysMegaIfPossible() {
            return this.bossesAlwaysMegaIfPossible;
        }

        public int getBossSpawnTicks() {
            return this.bossSpawnTicks;
        }

        public float getBossSpawnChance() {
            return this.bossSpawnChance;
        }
    }

    @ConfigSerializable
    public static class PokeStop {
        private boolean enabled = true;
        private int lootTime = 24;

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getLootTime() {
            return this.lootTime;
        }
    }

    @ConfigSerializable
    public static class PokeLoot {
        private boolean spawnNormal = true;
        private boolean spawnHidden = true;
        private boolean spawnGrotto = true;
        private PokeLootRate spawnRate = PokeLootRate.NORMAL;
        private EnumPokelootModes spawnMode = EnumPokelootModes.FCFS;
        private int lootTime = 24;

        public boolean isSpawnNormal() {
            return this.spawnNormal;
        }

        public boolean isSpawnHidden() {
            return this.spawnHidden;
        }

        public boolean isSpawnGrotto() {
            return this.spawnGrotto;
        }

        public PokeLootRate getSpawnRate() {
            return this.spawnRate;
        }

        public EnumPokelootModes getSpawnMode() {
            return this.spawnMode;
        }

        public int getLootTime() {
            return this.lootTime;
        }
    }
}

