/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.classloading;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import malte0811.ferritecore.ducks.FastMapStateHolder;
import net.minecraft.state.Property;
import net.minecraft.util.LazyValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FastImmutableMapDefiner {
    private static final Logger LOGGER = LogManager.getLogger((String)"FerriteCore - class definer");
    public static String GOOGLE_ACCESS_PREFIX = "/googleaccess/";
    public static String GOOGLE_ACCESS_SUFFIX = ".class_manual";
    private static final LazyValue<Definer> DEFINE_CLASS = new LazyValue(() -> {
        try {
            Method makePrivateLookup = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            Object privateLookup = makePrivateLookup.invoke(null, ImmutableMap.class, MethodHandles.lookup());
            Method defineClass = MethodHandles.Lookup.class.getMethod("defineClass", byte[].class);
            LOGGER.info("Using Java 9+ class definer");
            return (bytes, name) -> (Class)defineClass.invoke(privateLookup, new Object[]{bytes});
        }
        catch (Exception x) {
            try {
                Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                defineClass.setAccessible(true);
                ClassLoader loader = ImmutableMap.class.getClassLoader();
                LOGGER.info("Using Java 8 class definer");
                return (bytes, name) -> (Class)defineClass.invoke((Object)loader, name, bytes, 0, bytes.length);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    });
    private static final LazyValue<MethodHandle> MAKE_IMMUTABLE_FAST_MAP = new LazyValue(() -> {
        try {
            FastImmutableMapDefiner.defineInAppClassloader("com.google.common.collect.FerriteCoreEntrySetAccess");
            FastImmutableMapDefiner.defineInAppClassloader("com.google.common.collect.FerriteCoreImmutableMapAccess");
            Class<?> map = Class.forName("malte0811.ferritecore.fastmap.immutable.FastMapEntryImmutableMap");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.findConstructor(map, MethodType.methodType(Void.TYPE, FastMapStateHolder.class));
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    });

    public static ImmutableMap<Property<?>, Comparable<?>> makeMap(FastMapStateHolder<?> state) {
        try {
            return ((MethodHandle)MAKE_IMMUTABLE_FAST_MAP.func_179281_c()).invoke(state);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable x) {
            throw new RuntimeException(x);
        }
    }

    private static void defineInAppClassloader(String name) throws Exception {
        byte[] classBytes;
        InputStream byteInput = FastImmutableMapDefiner.class.getResourceAsStream(GOOGLE_ACCESS_PREFIX + name.replace('.', '/') + GOOGLE_ACCESS_SUFFIX);
        int bytesRead = byteInput.read(classBytes = new byte[byteInput.available()]);
        Preconditions.checkState((bytesRead == classBytes.length ? 1 : 0) != 0);
        Class<?> loaded = ((Definer)DEFINE_CLASS.func_179281_c()).define(classBytes, name);
        Preconditions.checkState((loaded.getClassLoader() == ImmutableMap.class.getClassLoader() ? 1 : 0) != 0);
    }

    private static interface Definer {
        public Class<?> define(byte[] var1, String var2) throws Exception;
    }
}

