/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.events;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.UUID;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.PlayerData;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import journeymap.common.util.PermissionsManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ForgeEvents {
    private static int playerUpdateTicks = 5;

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (((ServerOption)PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadar.get()).enabled() && ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v().size() > 1) {
            playerUpdateTicks = PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadarUpdateTime.get();
            ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_);
            if (world != null && world.func_72820_D() % (long)playerUpdateTicks == 0L) {
                this.sendPlayersOnRadarToPlayers();
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            this.sendConfigsToPlayer((ServerPlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            this.sendConfigsToPlayer((ServerPlayerEntity)event.getPlayer());
            PlayerData.getPlayerData().getPlayer((ServerPlayerEntity)event.getPlayer());
        }
    }

    private void sendConfigsToPlayer(ServerPlayerEntity player) {
        PermissionsManager.getInstance().sendPermissions(player);
    }

    private void sendPlayersOnRadarToPlayers() {
        GlobalProperties prop = PropertiesManager.getInstance().getGlobalProperties();
        ServerOption option = (ServerOption)prop.worldPlayerRadar.get();
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            boolean playerRadarEnabled = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension((Entity)player)).playerRadarEnabled.get();
            boolean receiverOp = Journeymap.isOp((PlayerEntity)player);
            if ((!option.enabled() || !playerRadarEnabled) && (!option.canOps() || !receiverOp)) continue;
            try {
                this.sendPlayerTrackingData(player, receiverOp);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    private void sendPlayerTrackingData(ServerPlayerEntity entityPlayerMP, boolean receiverOp) {
        ArrayList serverPlayers = new ArrayList(ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v());
        if (serverPlayers != null && serverPlayers.size() > 1) {
            GlobalProperties properties = PropertiesManager.getInstance().getGlobalProperties();
            for (ServerPlayerEntity radarPlayer : serverPlayers) {
                boolean sameDimension = entityPlayerMP.field_70170_p.func_234923_W_().equals(radarPlayer.field_70170_p.func_234923_W_());
                boolean sneaking = radarPlayer.func_225608_bj_();
                boolean invisible = this.isInvisibleTo(radarPlayer, entityPlayerMP);
                boolean hideOp = properties.hideOps.get();
                boolean hideSpectators = properties.hideSpectators.get() != false && radarPlayer.func_175149_v();
                boolean seeUnderground = this.seeUnderground(radarPlayer, receiverOp);
                boolean visible = sameDimension && (receiverOp && seeUnderground || !hideOp && !sneaking && !hideSpectators && !invisible && seeUnderground);
                visible = visible && this.isSelfHidden(radarPlayer, properties, receiverOp);
                UUID playerId = radarPlayer.func_110124_au();
                if (entityPlayerMP.func_110124_au().equals(playerId)) continue;
                Journeymap.getInstance().getDispatcher().sendPlayerLocationPacket(entityPlayerMP, radarPlayer, visible);
            }
        }
    }

    public boolean isInvisibleTo(ServerPlayerEntity player, ServerPlayerEntity to) {
        if (to.func_175149_v()) {
            return false;
        }
        ScorePlayerTeam team = (ScorePlayerTeam)player.func_96124_cp();
        return (team == null || to.func_96124_cp() != team || !team.func_98297_h()) && player.func_82150_aj();
    }

    private boolean seeUnderground(ServerPlayerEntity player, boolean isOp) {
        ServerOption seeUnderground = (ServerOption)PropertiesManager.getInstance().getGlobalProperties().seeUndergroundPlayers.get();
        BlockPos headPos = new BlockPos(player.func_174824_e(1.0f));
        if (!(World.field_234919_h_.equals(player.field_70170_p.func_234923_W_()) || ServerOption.ALL.equals(seeUnderground) || player.func_71121_q().func_226660_f_(headPos))) {
            return seeUnderground.hasOption(isOp);
        }
        return true;
    }

    private boolean isUnderground(ServerPlayerEntity player) {
        BlockPos headPos = new BlockPos(player.func_174824_e(1.0f));
        return !player.func_71121_q().func_226660_f_(headPos);
    }

    private boolean isSelfHidden(ServerPlayerEntity radarPlayer, GlobalProperties properties, boolean receiverOp) {
        if (((ServerOption)properties.allowMultiplayerSettings.get()).hasOption(receiverOp) || ServerOption.OPS.equals(properties.allowMultiplayerSettings.get())) {
            PlayerData.Player player = PlayerData.getPlayerData().getPlayer(radarPlayer);
            boolean hiddenUnderground = player.isHiddenUnderground() && this.isUnderground(radarPlayer) && !World.field_234919_h_.equals(radarPlayer.field_70170_p.func_234923_W_());
            return receiverOp || player.isVisible() && !hiddenUnderground;
        }
        return true;
    }
}

