/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.structure.logic;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapDecoration;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.forge.mixin.perf.async_locator.MerchantOfferAccess;
import org.embeddedt.modernfix.forge.structure.AsyncLocator;
import org.embeddedt.modernfix.forge.structure.logic.CommonLogic;

public class MerchantLogic {
    private static final boolean REMOVE_OFFER = false;

    private MerchantLogic() {
    }

    public static void invalidateMap(AbstractVillagerEntity merchant, ItemStack mapStack) {
        mapStack.func_200302_a((ITextComponent)new TranslationTextComponent("asynclocator.map.none"));
        Optional<MerchantOffer> offerOptional = merchant.func_213706_dY().stream().filter(offer -> offer.func_222200_d() == mapStack).findFirst();
        if (offerOptional.isPresent()) {
            MerchantLogic.removeOffer(merchant, offerOptional.get());
        } else {
            ModernFix.LOGGER.warn("Failed to find merchant offer for map");
        }
    }

    public static void removeOffer(AbstractVillagerEntity merchant, MerchantOffer offer) {
        ((MerchantOfferAccess)offer).setMaxUses(0);
        offer.func_222216_p();
    }

    public static void handleLocationFound(ServerWorld level, AbstractVillagerEntity merchant, ItemStack mapStack, String displayName, MapDecoration.Type destinationType, BlockPos pos) {
        if (pos == null) {
            MerchantLogic.invalidateMap(merchant, mapStack);
        } else {
            CommonLogic.updateMap(mapStack, level, pos, 2, destinationType, displayName);
        }
        if (merchant.func_70931_l_() instanceof ServerPlayerEntity) {
            ServerPlayerEntity tradingPlayer = (ServerPlayerEntity)merchant.func_70931_l_();
            tradingPlayer.func_213818_a(tradingPlayer.field_71070_bA.field_75152_c, merchant.func_213706_dY(), merchant instanceof VillagerEntity ? ((VillagerEntity)merchant).func_213700_eh().func_221132_c() : 1, merchant.func_213708_dV(), merchant.func_213705_dZ(), merchant.func_223340_ej());
        }
    }

    public static MerchantOffer updateMapAsync(Entity pTrader, int emeraldCost, String displayName, MapDecoration.Type destinationType, int maxUses, int villagerXp, Structure<?> destination) {
        return MerchantLogic.updateMapAsyncInternal(pTrader, emeraldCost, maxUses, villagerXp, (level, merchant, mapStack) -> AsyncLocator.locateLevel(level, ImmutableSet.of((Object)destination), merchant.func_233580_cy_(), 100, true).thenOnServerThread(pos -> MerchantLogic.handleLocationFound(level, merchant, mapStack, displayName, destinationType, pos)));
    }

    private static MerchantOffer updateMapAsyncInternal(Entity trader, int emeraldCost, int maxUses, int villagerXp, MapUpdateTask task) {
        if (trader instanceof AbstractVillagerEntity) {
            AbstractVillagerEntity merchant = (AbstractVillagerEntity)trader;
            ItemStack mapStack = CommonLogic.createEmptyMap();
            task.apply((ServerWorld)trader.field_70170_p, merchant, mapStack);
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, emeraldCost), new ItemStack((IItemProvider)Items.field_151111_aL), mapStack, maxUses, villagerXp, 0.2f);
        }
        return null;
    }

    public static interface MapUpdateTask {
        public void apply(ServerWorld var1, AbstractVillagerEntity var2, ItemStack var3);
    }
}

