/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.shadow.mixinextras.utils;

import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.embeddedt.modernfix.forge.shadow.mixinextras.utils.BlackboardMarkerExtension;

public class Blackboard {
    private static final Map<String, Object> IMPL = BlackboardMarkerExtension.getImpl();

    public static boolean has(String key) {
        return IMPL.containsKey(key);
    }

    public static <T> T get(String key) {
        return (T)IMPL.get(key);
    }

    public static <T> T getOrPut(String key, Supplier<T> supplier) {
        return (T)IMPL.computeIfAbsent(key, k -> supplier.get());
    }

    public static void put(String key, Object value) {
        IMPL.put(key, value);
    }

    public static <T> void modify(String key, UnaryOperator<T> operator) {
        IMPL.put(key, operator.apply(Blackboard.get(key)));
    }

    public static void remove(String key) {
        IMPL.remove(key);
    }
}

