/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.shadow.mixinextras.injector.wrapoperation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.embeddedt.modernfix.forge.shadow.mixinextras.injector.LateApplyingInjectorInfo;
import org.embeddedt.modernfix.forge.shadow.mixinextras.utils.Blackboard;
import org.embeddedt.modernfix.forge.shadow.mixinextras.utils.UniquenessHelper;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;

public class WrapOperationApplicatorExtension
implements IExtension {
    private static final Map<ITargetClassContext, List<Runnable[]>> QUEUED_INJECTIONS = Blackboard.getOrPut("WrapOperation_queuedInjections", () -> Collections.synchronizedMap(new HashMap()));

    static void offerInjection(ITargetClassContext targetClassContext, LateApplyingInjectorInfo injectorInfo) {
        Runnable[] runnableArray = new Runnable[2];
        runnableArray[0] = injectorInfo::lateInject;
        runnableArray[1] = injectorInfo::latePostInject;
        QUEUED_INJECTIONS.computeIfAbsent(targetClassContext, k -> new ArrayList()).add(runnableArray);
    }

    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    public void preApply(ITargetClassContext context) {
    }

    public void postApply(ITargetClassContext context) {
        List<Runnable[]> queuedInjections = QUEUED_INJECTIONS.get(context);
        if (queuedInjections != null) {
            for (Runnable[] injection : queuedInjections) {
                injection[0].run();
            }
            for (Runnable[] injection : queuedInjections) {
                injection[1].run();
            }
            QUEUED_INJECTIONS.remove(context);
        }
        UniquenessHelper.clear(context.getClassNode().name);
    }

    public void export(MixinEnvironment env, String name, boolean force, ClassNode classNode) {
    }
}

