/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.registry;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ObjectHolderRegistry;
import org.embeddedt.modernfix.ModernFix;

public class ObjectHolderClearer {
    public static void clearThrowables() {
        Set holders = (Set)ObfuscationReflectionHelper.getPrivateValue(ObjectHolderRegistry.class, null, (String)"objectHolders");
        if (holders != null) {
            int numCleared = 0;
            HashMap<Class, Field> throwableField = new HashMap<Class, Field>();
            Throwable singletonThrowable = new Throwable("[This stacktrace was cleared to save memory]");
            try {
                for (Consumer holder : holders) {
                    Field target = throwableField.computeIfAbsent(holder.getClass(), clz -> {
                        Field[] clzFields;
                        for (Field f : clzFields = clz.getDeclaredFields()) {
                            if (!Throwable.class.isAssignableFrom(f.getType())) continue;
                            f.setAccessible(true);
                            return f;
                        }
                        return null;
                    });
                    if (target == null) continue;
                    target.set(holder, singletonThrowable);
                    ++numCleared;
                }
            }
            catch (NoClassDefFoundError | ReflectiveOperationException | RuntimeException throwable) {
                // empty catch block
            }
            ModernFix.LOGGER.debug("Cleared " + numCleared + " object holder stacktrace references");
        }
    }
}

