/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.cache_model_materials;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.duck.ICachedMaterialsModel;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockModel.class})
@ClientOnlyMixin
public class VanillaModelMixin
implements ICachedMaterialsModel {
    private Collection<RenderMaterial> materialsCache = null;

    @Inject(method={"getMaterials"}, at={@At(value="HEAD")}, cancellable=true)
    private void useCachedMaterials(Function<ResourceLocation, IUnbakedModel> pModelGetter, Set<Pair<String, String>> pMissingTextureErrors, CallbackInfoReturnable<Collection<RenderMaterial>> cir) {
        if (this.materialsCache != null) {
            cir.setReturnValue(this.materialsCache);
        }
    }

    @Inject(method={"getMaterials"}, at={@At(value="RETURN")})
    private void storeCachedMaterials(Function<ResourceLocation, IUnbakedModel> pModelGetter, Set<Pair<String, String>> pMissingTextureErrors, CallbackInfoReturnable<Collection<RenderMaterial>> cir) {
        if (this.materialsCache == null) {
            this.materialsCache = Collections.unmodifiableCollection((Collection)cir.getReturnValue());
        }
    }

    @Override
    public void clearMaterialsCache() {
        this.materialsCache = null;
    }
}

