/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.api.helpers;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.embeddedt.modernfix.util.DynamicMap;

public final class ModelHelpers {
    public static ImmutableList<BlockState> getBlockStateForLocation(ModelResourceLocation location) {
        Optional blockOpt = Registry.field_212618_g.func_241873_b(new ResourceLocation(location.func_110624_b(), location.func_110623_a()));
        if (blockOpt.isPresent()) {
            return ModelBakeryHelpers.getBlockStatesForMRL((StateContainer<Block, BlockState>)((Block)blockOpt.get()).func_176194_O(), location);
        }
        return ImmutableList.of();
    }

    public static ImmutableList<BlockState> getBlockStateForLocation(StateContainer<Block, BlockState> definition, ModelResourceLocation location) {
        return ModelBakeryHelpers.getBlockStatesForMRL(definition, location);
    }

    public static Map<ResourceLocation, IBakedModel> createFakeTopLevelMap(BiFunction<ResourceLocation, IModelTransform, IBakedModel> modelGetter) {
        return new DynamicMap<ResourceLocation, IBakedModel>(location -> (IBakedModel)modelGetter.apply((ResourceLocation)location, (IModelTransform)ModelRotation.X0_Y0));
    }
}

