/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.packet.EntityIDSyncPacket;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.util.ClassInfoManager;
import org.embeddedt.modernfix.world.IntegratedWatchdog;

public class ModernFixClient {
    public static ModernFixClient INSTANCE;
    public static long worldLoadStartTime;
    private static int numRenderTicks;
    public static float gameStartTimeSeconds;
    public static boolean recipesUpdated;
    public static boolean tagsUpdated;
    public String brandingString = null;
    public static List<ModernFixClientIntegration> CLIENT_INTEGRATIONS;
    public static final Set<EntityDataManager> allEntityDatas;
    private static final Field entriesArrayField;

    public ModernFixClient() {
        INSTANCE = this;
        Minecraft.field_71444_a = new byte[0];
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.branding.F3Screen")) {
            this.brandingString = ModernFix.NAME + " " + ModernFixPlatformHooks.INSTANCE.getVersionString();
        }
        for (String className : ModernFixPlatformHooks.INSTANCE.getCustomModOptions().get((Object)"client_entrypoint")) {
            try {
                CLIENT_INTEGRATIONS.add((ModernFixClientIntegration)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                ModernFix.LOGGER.error("Could not instantiate integration {}", (Object)className, (Object)e);
            }
        }
    }

    public void resetWorldLoadStateMachine() {
        numRenderTicks = 0;
        worldLoadStartTime = -1L;
        recipesUpdated = false;
        tagsUpdated = false;
    }

    public void onGameLaunchFinish() {
        if (gameStartTimeSeconds >= 0.0f) {
            return;
        }
        gameStartTimeSeconds = (float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f;
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.measure_time.GameLoad")) {
            ModernFix.LOGGER.warn("Game took " + gameStartTimeSeconds + " seconds to start");
        }
        ModernFixPlatformHooks.INSTANCE.onLaunchComplete();
        ClassInfoManager.clear();
    }

    public void onRecipesUpdated() {
        recipesUpdated = true;
    }

    public void onTagsUpdated() {
        tagsUpdated = true;
    }

    public void onRenderTickEnd() {
        if (recipesUpdated && tagsUpdated && worldLoadStartTime != -1L && Minecraft.func_71410_x().field_71439_g != null && numRenderTicks++ >= 10) {
            float timeSpentLoading = (float)(System.nanoTime() - worldLoadStartTime) / 1.0E9f;
            if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.measure_time.WorldLoad")) {
                ModernFix.LOGGER.warn("Time from main menu to in-game was " + timeSpentLoading + " seconds");
                ModernFix.LOGGER.warn("Total time to load game and open world was " + (timeSpentLoading + gameStartTimeSeconds) + " seconds");
            }
            this.resetWorldLoadStateMachine();
        }
    }

    private static boolean compareAndSwitchIds(Class<? extends Entity> eClass, String fieldName, DataParameter<?> accessor, int newId) {
        if (accessor.field_187157_a != newId) {
            ModernFix.LOGGER.warn("Corrected ID mismatch on {} field {}. Client had {} but server wants {}.", eClass, (Object)fieldName, (Object)accessor.field_187157_a, (Object)newId);
            accessor.field_187157_a = newId;
            return true;
        }
        ModernFix.LOGGER.debug("{} {} ID fine: {}", eClass, (Object)fieldName, (Object)newId);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleEntityIDSync(EntityIDSyncPacket packet) {
        Map<Class<? extends Entity>, List<Pair<String, Integer>>> info = packet.getFieldInfo();
        boolean fixNeeded = false;
        for (Map.Entry<Class<? extends Entity>, List<Pair<String, Integer>>> entry : info.entrySet()) {
            Class<? extends Entity> eClass = entry.getKey();
            for (Pair<String, Integer> field : entry.getValue()) {
                String fieldName = (String)field.getFirst();
                int newId = (Integer)field.getSecond();
                try {
                    Field f = eClass.getDeclaredField(fieldName);
                    f.setAccessible(true);
                    DataParameter accessor = (DataParameter)f.get(null);
                    if (!ModernFixClient.compareAndSwitchIds(eClass, fieldName, accessor, newId)) continue;
                    fixNeeded = true;
                }
                catch (NoSuchFieldException e) {
                    ModernFix.LOGGER.warn("Couldn't find field on {}: {}", eClass, (Object)fieldName);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        }
        Set<EntityDataManager> set = allEntityDatas;
        synchronized (set) {
            if (fixNeeded) {
                ArrayList<EntityDataManager> dataEntries = new ArrayList<EntityDataManager>(allEntityDatas);
                for (EntityDataManager manager : dataEntries) {
                    Int2ObjectOpenHashMap fixedMap = new Int2ObjectOpenHashMap();
                    ArrayList items = new ArrayList(manager.field_187234_c.values());
                    for (EntityDataManager.DataEntry item : items) {
                        fixedMap.put(item.func_187205_a().field_187157_a, (Object)item);
                    }
                    manager.field_187235_d.writeLock().lock();
                    try {
                        manager.field_187234_c.replaceAll((id, parameter) -> (EntityDataManager.DataEntry)fixedMap.get(id.intValue()));
                        if (entriesArrayField == null) continue;
                        try {
                            EntityDataManager.DataEntry[] dataArray = new EntityDataManager.DataEntry[items.size()];
                            for (int i = 0; i < dataArray.length; ++i) {
                                dataArray[i] = (EntityDataManager.DataEntry)fixedMap.get(i);
                            }
                            entriesArrayField.set(manager, dataArray);
                        }
                        catch (ReflectiveOperationException e) {
                            ModernFix.LOGGER.error((Object)e);
                        }
                    }
                    finally {
                        manager.field_187235_d.writeLock().unlock();
                    }
                }
            }
            allEntityDatas.clear();
        }
    }

    public void onServerStarted(MinecraftServer server) {
        if (!ModernFixMixinPlugin.instance.isOptionEnabled("feature.integrated_server_watchdog.IntegratedWatchdog")) {
            return;
        }
        IntegratedWatchdog watchdog = new IntegratedWatchdog(server);
        watchdog.start();
    }

    static {
        Field field;
        worldLoadStartTime = -1L;
        gameStartTimeSeconds = -1.0f;
        tagsUpdated = false;
        CLIENT_INTEGRATIONS = new CopyOnWriteArrayList<ModernFixClientIntegration>();
        allEntityDatas = Collections.newSetFromMap(new WeakHashMap());
        try {
            field = EntityDataManager.class.getDeclaredField("entriesArray");
            field.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            field = null;
        }
        entriesArrayField = field;
    }
}

