/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import com.google.common.base.Strings;
import java.util.UUID;
import journeymap.client.Constants;
import journeymap.client.api.option.KeyedEnum;
import journeymap.client.render.texture.JMTexture;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import net.minecraft.util.ResourceLocation;

public enum EntityDisplay implements KeyedEnum
{
    LargeDots("jm.common.entity_display.dots", TextureCache.MobDot, TextureCache.MobDotArrow),
    LargeIcons("jm.common.entity_display.icons", null, TextureCache.MobIconArrow);

    public final String key;
    private final ResourceLocation defaultTexture;
    private final ResourceLocation showHeadingTexture;

    private EntityDisplay(String key, ResourceLocation defaultTexture, ResourceLocation showHeadingTexture) {
        this.key = key;
        this.defaultTexture = defaultTexture;
        this.showHeadingTexture = showHeadingTexture;
    }

    public static TextureImpl getLocatorTexture(EntityDisplay entityDisplay, boolean showHeading) {
        return TextureCache.getTexture(showHeading ? entityDisplay.showHeadingTexture : entityDisplay.defaultTexture);
    }

    public static TextureImpl getEntityTexture(EntityDisplay entityDisplay) {
        return EntityDisplay.getEntityTexture(entityDisplay, null, null);
    }

    public static TextureImpl getEntityTexture(EntityDisplay entityDisplay, UUID entityId, String playerName) {
        switch (entityDisplay) {
            case LargeDots: {
                return TextureCache.getTexture(TextureCache.MobDotChevron);
            }
        }
        if (!Strings.isNullOrEmpty((String)playerName)) {
            return TextureCache.getPlayerSkin(entityId, playerName);
        }
        return null;
    }

    public static JMTexture getEntityTexture(EntityDisplay entityDisplay, ResourceLocation iconLocation) {
        if (entityDisplay == LargeDots) {
            return TextureCache.getTexture(TextureCache.MobDotChevron);
        }
        return TextureCache.getTextureForEntities(iconLocation);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String toString() {
        return Constants.getString(this.key);
    }

    public boolean isDots() {
        return this == LargeDots;
    }

    public boolean isLarge() {
        return this == LargeDots || this == LargeIcons;
    }

    public EntityDisplay getDot() {
        if (this == LargeIcons) {
            return LargeDots;
        }
        return this;
    }
}

