/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.command;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.command.JMCommand;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSource;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.util.Strings;

public class ClientCommandInvoker
implements JMCommand {
    Map<String, JMCommand> commandMap = new HashMap<String, JMCommand>();

    public ClientCommandInvoker registerSub(JMCommand command) {
        this.commandMap.put(command.getName().toLowerCase(), command);
        return this;
    }

    @Override
    public String getName() {
        return "jm";
    }

    @Override
    public String getUsage(ICommandSource sender) {
        StringBuffer sb = new StringBuffer();
        for (JMCommand command : this.commandMap.values()) {
            String usage = command.getUsage(sender);
            if (Strings.isEmpty((CharSequence)usage)) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("/jm ").append(usage);
        }
        return sb.toString();
    }

    @Override
    public int execute(ICommandSource sender, String[] args2) throws CommandException {
        try {
            if (args2.length > 0) {
                JMCommand command = this.getSubCommand(args2);
                if (command != null) {
                    String[] subArgs = Arrays.copyOfRange(args2, 1, args2.length);
                    command.execute(sender, subArgs);
                }
            } else {
                sender.func_145747_a((ITextComponent)Constants.getStringTextComponent(this.getUsage(sender)), Util.field_240973_b_);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toPartialString(t));
            throw new CommandException((ITextComponent)Constants.getStringTextComponent("Error in /jm: " + t));
        }
        return 0;
    }

    public JMCommand getSubCommand(String[] args2) {
        JMCommand command;
        if (args2.length > 0 && (command = this.commandMap.get(args2[0].toLowerCase())) != null) {
            return command;
        }
        return null;
    }

    public String getPossibleCommands() {
        return Joiner.on((String)",").join(this.commandMap.keySet());
    }
}

