/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import com.pixelmonmod.tcg.tileentity.ServerOwnedTileEntityBattleController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class RenderStateSyncPacket
extends AbstractTCGPacket {
    private BlockPos blockPos;
    private GamePhase gamePhase;
    private int currentTurn;
    private PlayerClientOpponentState[] players;
    private GameServerState server;
    private boolean isShadowGame;

    public RenderStateSyncPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public RenderStateSyncPacket(BlockPos blockPos, GameServerState server, PlayerEntity entityPlayer, ServerOwnedTileEntityBattleController bc) {
        this();
        this.blockPos = blockPos;
        this.gamePhase = server.getGamePhase();
        this.currentTurn = server.getCurrentTurn();
        this.isShadowGame = bc.isShadowGame();
        this.players = new PlayerClientOpponentState[server.getPlayers().length];
        for (int i = 0; i < server.getPlayers().length; ++i) {
            PlayerServerState player = server.getPlayer(i);
            if (player == null) continue;
            this.players[i] = new PlayerClientOpponentState(player, server.getGamePhase(), server, player.getEntityPlayer() == entityPlayer);
        }
        this.server = server;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.blockPos);
        buffer.writeInt(this.gamePhase.ordinal());
        buffer.writeInt(this.currentTurn);
        buffer.writeBoolean(this.isShadowGame);
        buffer.writeInt(this.players.length);
        for (PlayerClientOpponentState player : this.players) {
            buffer.writeBoolean(player != null);
            if (player == null) continue;
            player.write(buffer);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.blockPos = buffer.func_179259_c();
        this.gamePhase = GamePhase.values()[buffer.readInt()];
        this.currentTurn = buffer.readInt();
        this.isShadowGame = buffer.readBoolean();
        int size = buffer.readInt();
        this.players = new PlayerClientOpponentState[size];
        for (int i = 0; i < size; ++i) {
            if (!buffer.readBoolean()) continue;
            this.players[i] = new PlayerClientOpponentState(buffer, this.server);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        ClientWorld w;
        BattleOwnedTileEntityController b;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity e = mc.field_71439_g;
        if (mc.field_71441_e != null && (b = (BattleOwnedTileEntityController)(w = mc.field_71441_e).func_175625_s(this.blockPos)) != null) {
            b.setRenderClientSideValues(this.gamePhase, this.currentTurn, this.players);
            b.setShadowGame(this.isShadowGame);
        }
    }
}

