/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.data;

import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.network.data.TCGPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class AbstractTCGPacket
implements TCGPacket {
    private final boolean sync;
    private final PacketDirection direction;

    public AbstractTCGPacket(PacketDirection direction) {
        this(direction, false);
    }

    public AbstractTCGPacket(PacketDirection direction, boolean sync) {
        this.direction = direction;
        this.sync = sync;
    }

    public AbstractTCGPacket(boolean sync) {
        this.direction = null;
        this.sync = sync;
    }

    @Override
    public void encode(PacketBuffer buffer) {
    }

    @Override
    public void decode(PacketBuffer buffer) {
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        if (this.sync) {
            context.enqueueWork(() -> this.handlePacket(context));
        } else {
            this.handlePacket(context);
        }
        context.setPacketHandled(true);
    }

    protected abstract void handlePacket(NetworkEvent.Context var1);

    protected void reply(NetworkEvent.Context context, Object packet) {
        TCG.network.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), packet);
    }
}

