/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.item;

import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import com.pixelmonmod.tcg.client.container.BinderContainer;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BinderItem
extends Item {
    private static final String name = "binder";

    public BinderItem() {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_TCG).func_200917_a(1));
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!world.field_72995_K && !player.func_213453_ef()) {
            BinderItem.openBinder(player.func_184586_b(hand), (ServerPlayerEntity)player);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean onDroppedByPlayer(ItemStack item, PlayerEntity player) {
        if (player.field_71070_bA instanceof BinderContainer) {
            player.func_71053_j();
            return false;
        }
        return super.onDroppedByPlayer(item, player);
    }

    public static void openBinder(final ItemStack stack, final ServerPlayerEntity player) {
        if (!(stack.func_77973_b() instanceof BinderItem)) {
            return;
        }
        if (!player.field_71071_by.func_70431_c(stack)) {
            return;
        }
        final Binder binder = Binder.readFromItemStack((PlayerEntity)player, stack);
        SimpleNamedContainerProvider containerProvider = new SimpleNamedContainerProvider((a, b, c) -> new BinderContainer(a, player.field_71071_by, binder), (ITextComponent)new TranslationTextComponent(""));
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, binder::writeToBuffer);
        player.field_71070_bA.func_75132_a(new IContainerListener(){

            public void func_71110_a(Container p_71110_1_, NonNullList<ItemStack> p_71110_2_) {
                if (!player.field_71071_by.func_70431_c(stack)) {
                    return;
                }
                binder.writeToStack(stack);
            }

            public void func_71111_a(Container container, int slot, ItemStack item) {
                if (!player.field_71071_by.func_70431_c(stack)) {
                    return;
                }
                if (slot >= binder.inventory.func_70302_i_()) {
                    return;
                }
                binder.inventory.func_70299_a(slot, item);
                binder.writeToStack(stack);
            }

            public void func_71112_a(Container p_71112_1_, int p_71112_2_, int p_71112_3_) {
                if (!player.field_71071_by.func_70431_c(stack)) {
                    return;
                }
                binder.writeToStack(stack);
            }
        });
    }

    public static class Binder {
        public Inventory inventory;
        private int slot;
        private int page;

        public Binder(Inventory inventory, int slot) {
            this.inventory = inventory;
            this.slot = slot;
            this.page = 0;
        }

        public int getSlot() {
            return this.slot;
        }

        public void writeToStack(ItemStack stack) {
            CompoundNBT compound = stack.func_196082_o();
            this.saveInventory(compound);
        }

        public void writeToBuffer(PacketBuffer buffer) {
            CompoundNBT compound = new CompoundNBT();
            this.saveInventory(compound);
            buffer.func_150786_a(compound);
            buffer.writeInt(this.slot);
        }

        public void saveInventory(CompoundNBT compoundNBT) {
            ListNBT list = new ListNBT();
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("slot", i);
                nbt.func_218657_a("item", (INBT)this.inventory.func_70301_a(i).func_77955_b(new CompoundNBT()));
                list.add((Object)nbt);
            }
            compoundNBT.func_218657_a("PokeBagItems", (INBT)list);
        }

        public int getPage() {
            return this.page;
        }

        public int getSizePage() {
            return 24;
        }

        public void decrementPage() {
            if (this.page > 0) {
                this.page = this.getPage() - 1;
            }
        }

        public void incrementPage() {
            if (this.page < 11) {
                this.page = this.getPage() + 1;
            }
        }

        public static Inventory fromTag(CompoundNBT nbt) {
            ListNBT list = nbt.func_150295_c("PokeBagItems", 10);
            Inventory inventory = new Inventory(288);
            for (INBT inbt : list) {
                CompoundNBT listNBT = (CompoundNBT)inbt;
                inventory.func_70299_a(listNBT.func_74762_e("slot"), ItemStack.func_199557_a((CompoundNBT)listNBT.func_74775_l("item")));
            }
            return inventory;
        }

        public static Binder readFromItemStack(PlayerEntity player, ItemStack stack) {
            if (!(stack.func_77973_b() instanceof BinderItem)) {
                return null;
            }
            CompoundNBT compound = stack.func_77978_p();
            Inventory inventory = new Inventory(288);
            if (compound != null && compound.func_74764_b("TCGBinderItems")) {
                inventory = Binder.fromTag(compound);
            }
            int slot = -1;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack item = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (!Objects.equals(item, stack)) continue;
                slot = i;
                break;
            }
            Binder binder = new Binder(inventory, slot);
            inventory.func_110134_a(p_76316_1_ -> binder.writeToStack(stack));
            return binder;
        }

        public static Binder fromBuffer(PacketBuffer buffer) {
            CompoundNBT compound = buffer.func_150793_b();
            Inventory inventory = Binder.fromTag(compound);
            return new Binder(inventory, buffer.readInt());
        }
    }
}

